/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.util;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.builder.ExcelWriterTableBuilder;
import com.alibaba.excel.write.handler.CellWriteHandler;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.WriteTable;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class ExcelFillCellMergeStrategy
implements CellWriteHandler {
    private int[] mergeColumnIndex;
    private int mergeRowIndex;

    public ExcelFillCellMergeStrategy() {
    }

    public ExcelFillCellMergeStrategy(int mergeRowIndex, int[] mergeColumnIndex) {
        this.mergeRowIndex = mergeRowIndex;
        this.mergeColumnIndex = mergeColumnIndex;
    }

    public void beforeCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Row row, Head head, Integer integer, Integer integer1, Boolean aBoolean) {
    }

    public void afterCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Cell cell, Head head, Integer integer, Boolean aBoolean) {
    }

    public void afterCellDataConverted(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, CellData cellData, Cell cell, Head head, Integer integer, Boolean aBoolean) {
    }

    public void afterCellDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, List<CellData> list, Cell cell, Head head, Integer integer, Boolean aBoolean) {
        int curRowIndex = cell.getRowIndex();
        int curColIndex = cell.getColumnIndex();
        if (curRowIndex > this.mergeRowIndex) {
            for (int i = 0; i < this.mergeColumnIndex.length; ++i) {
                if (curColIndex != this.mergeColumnIndex[i]) continue;
                this.mergeWithPrevRow(writeSheetHolder, cell, curRowIndex, curColIndex);
                break;
            }
        }
    }

    private void mergeWithPrevRow(WriteSheetHolder writeSheetHolder, Cell cell, int curRowIndex, int curColIndex) {
        Object preData;
        Object curData = cell.getCellTypeEnum() == CellType.STRING ? cell.getStringCellValue() : Double.valueOf(cell.getNumericCellValue());
        Cell preCell = cell.getSheet().getRow(curRowIndex - 1).getCell(curColIndex);
        Object object = preData = preCell.getCellTypeEnum() == CellType.STRING ? preCell.getStringCellValue() : Double.valueOf(preCell.getNumericCellValue());
        if (curData.equals(preData)) {
            Sheet sheet = writeSheetHolder.getSheet();
            List mergeRegions = sheet.getMergedRegions();
            boolean isMerged = false;
            for (int i = 0; i < mergeRegions.size() && !isMerged; ++i) {
                CellRangeAddress cellRangeAddr = (CellRangeAddress)mergeRegions.get(i);
                if (!cellRangeAddr.isInRange(curRowIndex - 1, curColIndex)) continue;
                sheet.removeMergedRegion(i);
                cellRangeAddr.setLastRow(curRowIndex);
                sheet.addMergedRegion(cellRangeAddr);
                isMerged = true;
            }
            if (!isMerged) {
                CellRangeAddress cellRangeAddress = new CellRangeAddress(curRowIndex - 1, curRowIndex, curColIndex, curColIndex);
                sheet.addMergedRegion(cellRangeAddress);
            }
        }
    }

    public static void main(String[] args) {
        ArrayList headList = new ArrayList();
        ArrayList<String> heads1 = new ArrayList<String>();
        heads1.add("\u603b\u8868\u5934");
        heads1.add("\u8868\u59341");
        headList.add(heads1);
        ArrayList<String> heads2 = new ArrayList<String>();
        heads2.add("\u603b\u8868\u5934");
        heads2.add("\u8868\u59342");
        headList.add(heads2);
        ArrayList<String> heads3 = new ArrayList<String>();
        heads3.add("\u603b\u8868\u5934");
        heads3.add("\u8868\u59343");
        headList.add(heads3);
        ArrayList<String> heads4 = new ArrayList<String>();
        heads4.add("\u603b\u8868\u5934");
        heads4.add("\u8868\u59344");
        headList.add(heads4);
        ArrayList data = new ArrayList();
        ArrayList<String> data1 = new ArrayList<String>();
        data1.add("\u5185\u5bb91");
        data1.add("\u5185\u5bb91-2");
        data1.add("\u5185\u5bb93");
        data1.add("\u5185\u5bb94");
        ArrayList<String> data2 = new ArrayList<String>();
        data2.add("\u5185\u5bb91");
        data2.add("\u5185\u5bb92-2");
        data2.add("\u5185\u5bb93");
        data2.add("\u5185\u5bb94");
        data.add(data1);
        data.add(data2);
        try {
            String file = "D:\\out2.xlsx";
            FileOutputStream outputStream = new FileOutputStream(new File(file));
            ExcelWriter writer = EasyExcel.write((OutputStream)outputStream).build();
            WriteSheet sheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)0).needHead(Boolean.FALSE)).sheetName("sheet\u9875\u540d\u79f0").build();
            WriteTable table = ((ExcelWriterTableBuilder)((ExcelWriterTableBuilder)((ExcelWriterTableBuilder)EasyExcel.writerTable((Integer)1).head(headList)).registerWriteHandler((WriteHandler)new ExcelFillCellMergeStrategy(1, new int[]{0, 1, 2}))).needHead(Boolean.TRUE)).build();
            writer.write(data, sheet, table);
            ArrayList<String> data3 = new ArrayList<String>();
            data3.add("\u5185\u5bb911");
            data3.add("\u5185\u5bb921-2");
            data3.add("\u5185\u5bb931");
            data3.add("\u5185\u5bb941");
            data.add(data3);
            WriteSheet sheet1 = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)1).needHead(Boolean.FALSE)).sheetName("sheet\u9875\u540d\u79f02").build();
            WriteTable table1 = ((ExcelWriterTableBuilder)((ExcelWriterTableBuilder)((ExcelWriterTableBuilder)EasyExcel.writerTable((Integer)2).head(headList)).registerWriteHandler((WriteHandler)new ExcelFillCellMergeStrategy(1, new int[]{0, 1, 2}))).needHead(Boolean.TRUE)).build();
            writer.write(data, sheet1, table1);
            writer.finish();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int[] getMergeColumnIndex() {
        return this.mergeColumnIndex;
    }

    public int getMergeRowIndex() {
        return this.mergeRowIndex;
    }

    public void setMergeColumnIndex(int[] mergeColumnIndex) {
        this.mergeColumnIndex = mergeColumnIndex;
    }

    public void setMergeRowIndex(int mergeRowIndex) {
        this.mergeRowIndex = mergeRowIndex;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExcelFillCellMergeStrategy)) {
            return false;
        }
        ExcelFillCellMergeStrategy other = (ExcelFillCellMergeStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getMergeColumnIndex(), other.getMergeColumnIndex())) {
            return false;
        }
        return this.getMergeRowIndex() == other.getMergeRowIndex();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExcelFillCellMergeStrategy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getMergeColumnIndex());
        result = result * 59 + this.getMergeRowIndex();
        return result;
    }

    public String toString() {
        return "ExcelFillCellMergeStrategy(mergeColumnIndex=" + Arrays.toString(this.getMergeColumnIndex()) + ", mergeRowIndex=" + this.getMergeRowIndex() + ")";
    }
}

