/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.algorithm.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.valid.AddGroup;
import com.artfess.dataShare.algorithm.manager.BizAlgorithmVersionManager;
import com.artfess.dataShare.algorithm.model.BizAlgorithmVersion;
import com.artfess.dataShare.algorithm.vo.TaskVersionVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/biz/algorithm/version/v1/"})
@Api(tags={"\u7b97\u6cd5\u63a8\u7406\u7ba1\u7406----\u7b97\u6cd5\u63a8\u7406\u4efb\u52a1\u7248\u672c\u7ba1\u7406"})
@ApiGroup(group={"group_biz_dataShare"})
public class BizAlgorithmVersionController
extends BaseController<BizAlgorithmVersionManager, BizAlgorithmVersion> {
    @PostMapping(value={"/saveTaskVersion"})
    @ApiOperation(value="\u4fdd\u5b58\u7b97\u6cd5\u63a8\u7406\u4fe1\u606f")
    public CommonResult<String> saveTaskVersion(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) TaskVersionVo task) throws Exception {
        ((BizAlgorithmVersionManager)this.baseService).saveTaskVersion(task);
        return new CommonResult(true, "\u6dfb\u52a0\u6210\u529f");
    }

    @PostMapping(value={"/queryVersion"})
    @ApiOperation(value="\u67e5\u8be2\u7b97\u6cd5\u63a8\u7406\u4fe1\u606f")
    public TaskVersionVo queryVersion(@ApiParam(name="versionId", value="\u7248\u672cID") @RequestParam String versionId) throws Exception {
        return ((BizAlgorithmVersionManager)this.baseService).queryVersion(versionId);
    }

    @PostMapping(value={"/queryNewId"})
    @ApiOperation(value="\u83b7\u53d6\u4e00\u4e2a\u6700\u65b0\u7684ID")
    public CommonResult<String> queryId() throws Exception {
        return CommonResult.success((Object)UniqueIdUtil.getSuid(), (String)"");
    }

    @PostMapping(value={"/getNewVersionCode"})
    @ApiOperation(value="\u83b7\u53d6\u4e00\u4e2a\u6700\u65b0\u7684\u7248\u672c\u53f7")
    public CommonResult<String> getNewVersionCode(@ApiParam(name="taskId", value="\u4efb\u52a1ID") @RequestParam String taskId) throws Exception {
        String maxVersionCode = ((BizAlgorithmVersionManager)this.baseService).getNewVersionCode(taskId);
        return CommonResult.success((Object)maxVersionCode, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/saveAsTaskVersion"})
    @ApiOperation(value="\u4fdd\u5b58\u65b0\u7248\u672c\u7b97\u6cd5\u63a8\u7406\u7248\u672c\u4fe1\u606f")
    public CommonResult<String> saveAsTaskVersion(@ApiParam(name="id", value="id") @RequestParam String id) throws Exception {
        String newId = ((BizAlgorithmVersionManager)this.baseService).saveAsTaskVersion(id);
        return CommonResult.success((Object)newId, (String)"\u4fdd\u5b58\u65b0\u7248\u672c\u7b97\u6cd5\u63a8\u7406\u7248\u672c\u4fe1\u606f\u6210\u529f");
    }
}

