/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.table.operator.impl.dm;

import com.artfess.base.util.AppUtil;
import com.artfess.table.model.Index;
import com.artfess.table.model.impl.DefaultIndex;
import com.artfess.table.operator.ITableOperator;
import com.artfess.table.operator.impl.BaseIndexOperator;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.jdbc.core.RowMapper;

public class DmIndexOperator
extends BaseIndexOperator {
    protected int BATCH_SIZE = 100;

    @Override
    public void createIndex(Index index) throws SQLException {
        String sql = this.genIndexDDL(index);
        this.jdbcTemplate.execute(sql);
    }

    private String genIndexDDL(Index index) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE ");
        sql.append("INDEX ");
        sql.append(index.getIndexName());
        sql.append(" ON ");
        sql.append(index.getTableName());
        sql.append("(");
        for (String field : index.getColumnList()) {
            sql.append(field);
            sql.append(",");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
        return sql.toString();
    }

    @Override
    public void dropIndex(String tableName, String indexName) {
        String sql = "DROP INDEX " + indexName;
        this.jdbcTemplate.execute(sql);
    }

    @Override
    public Index getIndex(String tableName, String indexName) {
        String sql = "SELECT IDX.TABLE_NAME,IDX.TABLE_TYPE,IDX.INDEX_NAME, IDX.INDEX_TYPE,IDX.UNIQUENESS,IDX.STATUS,IDC.COLUMN_NAME,DBMS_METADATA.GET_DDL('INDEX',idx.INDEX_NAME) AS DDL FROM USER_INDEXES IDX JOIN USER_IND_COLUMNS IDC ON IDX.INDEX_NAME=IDC.INDEX_NAME  WHERE IDX.INDEX_NAME=UPPER('" + indexName + "')";
        List<Index> indexes = this.getIndexesBySql(sql);
        List<Index> indexList = this.mergeIndex(indexes);
        if (indexList.size() > 0) {
            return this.dedicatePKIndex(indexList.get(0));
        }
        return null;
    }

    private List<Index> getIndexesBySql(String sql) {
        List indexes = this.jdbcTemplate.query(sql, (RowMapper)new RowMapper<Index>(){

            public Index mapRow(ResultSet rs, int rowNum) throws SQLException {
                DefaultIndex index = new DefaultIndex();
                index.setTableName(rs.getString("TABLE_NAME"));
                index.setTableType(rs.getString("TABLE_TYPE"));
                index.setIndexName(rs.getString("INDEX_NAME"));
                index.setIndexType(rs.getString("INDEX_TYPE"));
                index.setUnique(rs.getString("UNIQUENESS").equalsIgnoreCase("UNIQUE"));
                index.setIndexStatus(rs.getString("STATUS"));
                index.setIndexDdl(rs.getString("DDL"));
                ArrayList<String> columnList = new ArrayList<String>();
                columnList.add(rs.getString("COLUMN_NAME"));
                index.setColumnList(columnList);
                return index;
            }
        });
        return indexes;
    }

    private List<Index> mergeIndex(List<Index> indexes) {
        ArrayList<Index> indexList = new ArrayList<Index>();
        for (Index index : indexes) {
            boolean found = false;
            for (Index index1 : indexList) {
                if (!index.getIndexName().equals(index1.getIndexName()) || !index.getTableName().equals(index1.getTableName())) continue;
                index1.getColumnList().add(index.getColumnList().get(0));
                found = true;
                break;
            }
            if (found) continue;
            indexList.add(index);
        }
        return indexList;
    }

    private List<String> getPKColumns(String tableName) throws SQLException {
        ITableOperator tableOperator = (ITableOperator)AppUtil.getBean(ITableOperator.class);
        return tableOperator.getPKColumns(tableName);
    }

    private Index dedicatePKIndex(Index index) {
        try {
            List<String> pkCols = this.getPKColumns(index.getIndexName());
            if (this.isListEqual(index.getColumnList(), pkCols)) {
                index.setPkIndex(true);
            } else {
                index.setPkIndex(false);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return index;
    }

    private boolean isListEqual(List<String> list1, List<String> list2) {
        if (list1 == null && list2 == null) {
            return true;
        }
        if (list1 == null || list2 == null) {
            return false;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        return list1.containsAll(list2);
    }

    @Override
    public void rebuildIndex(String tableName, String indexName) {
        String sql = "ALTER INDEX " + indexName + " REBUILD";
        this.jdbcTemplate.execute(sql);
    }

    @Override
    public List<Index> getIndexByName(String indexName) throws SQLException {
        return null;
    }

    @Override
    public List<Index> getIndexsByTable(String tableName) throws SQLException {
        return null;
    }
}

