export const bigDataMixin = {
  data() {
    return {
      dailyChart: null,
      checkChart: null,
      workChart: null,
      queryChart: {
        site: {
          params: {
            accDateMonth: '',
            accDateYear:this.getYear()
          }
        },
        daily: {
          params: {
            accDateMonth: '',
            accDateYear:this.getYear()
          }
        },
        check: {
          params: {
            accDateMonth: '',
            accDateYear:this.getYear()
          }
        },
        work: {
          params: {
            accDateMonth: '',
            accDateYear:this.getYear()
          }
        },
        amount: {
          //养护金额
          params: {
            accDateMonth: '',
            accDateYear:this.getYear()
          }
        },
        disease: {
          params: {
            accDateMonth: '',
            accDateYear:this.getYear(),
            roadSegmentId: ''
          }
        },
        diseaseType: {
          params: {
            accDateMonth: '',
            accDateYear:this.getYear(),
            roadSegmentId: ''
          }
        },
        diseaseDay: {
          params: {
            accDateMonth: '',
            accDateYear:this.getYear(),
            roadSegmentId: ''
          }
        },
        task: {
          params: {
            accDateMonth: '',
            accDateYear:this.getYear(),
            roadSegmentId: ''
          }
        }
      },
      queryTopAmount: {
        params: {}
      },
      // 视频
      showVideoModel: false
    }
  },
  methods: {
    changeDate() {
      let model = [
        'site',
        'daily',
        'check',
        'work',
        'amount',
        'disease',
        'diseaseType',
        'diseaseDay',
        'task'
      ]
      console.log(this.value)
      if(this.value==null){
        this.value=' '
      }
      model.forEach(item => {
        this.queryChart[item].params.accDateYear = ''
        this.queryChart[item].params.accDateMonth = this.value
      })
      console.log(this.value,'value')
      this.queryTopAmount.params.accDateMonth = this.value
      this.queryTopAmount.params.accDateYear = ''
  
      this.getBizTopData() //业务概况底部数据
      this.getCheckJson() //定期/经常检查
      this.getWorkJson() //养护工单
      this.getSiteJson('site') //巡查巡检
      this.getSiteJson('daily') //日常养护
      this.getMaintenanceAmount() //养护金额
      this.getDiseaseNumber() //病害数量
      this.getDiseaseType('change') //病害类型
      this.getDiseaseAverDay('change')  //病害平均处理天数
      this.getTaskImplementation()  //任务执行情况
    },
    getYear() {
      var dd = new Date();
      var year = dd.getFullYear() + Number(0);
      return year;
    },
    showvideo() {
      this.showVideoModel = true
    }
  }
}
