package com.artfess.yhxt.task.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.User;
import com.artfess.yhxt.specialcheck.vo.SiteInspectionVo;
import com.artfess.yhxt.task.model.TaskAlreadyHandleHistory;
import com.artfess.yhxt.task.dao.TaskAlreadyHandleHistoryDao;
import com.artfess.yhxt.task.manager.TaskAlreadyHandleHistoryManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.yhxt.task.model.TaskWaitHandle;
import com.artfess.yhxt.task.vo.TaskAlreadyHandleHistoryVo;
import com.artfess.yhxt.task.vo.TaskWaitHandleVo;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;

/**
 * 主要是从待办处理完毕之后，向“已办”表中插入相关数据 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2021-09-16
 */
@Service
public class TaskAlreadyHandleHistoryManagerImpl extends BaseManagerImpl<TaskAlreadyHandleHistoryDao, TaskAlreadyHandleHistory> implements TaskAlreadyHandleHistoryManager {

    @Resource
    private BaseContext baseContext;
    @Resource
    private UserManager userManager;

    @Override
    public PageList<TaskAlreadyHandleHistoryVo> queryTaskWaitHandleHistory(QueryFilter<TaskAlreadyHandleHistory> queryFilter) {
        //登录者ID
        String userId = baseContext.getCurrentUserId();
        //登录人账号
        String userAccout = baseContext.getCurrentUserAccout();
        //登录人账号
        String userName = baseContext.getCurrentUserName();
        //当前时间
        LocalDateTime time = LocalDateTime.now();
        //登录人单位id
        String deptId = baseContext.getCurrentDeptId();
        //登录人单位名称
        String deptName = baseContext.getCurrentDeptName();
        //发送单位名称
        String sendDeptName = baseContext.getCurrentDeptName();

        queryFilter.addFilter("RECEIVE_USER_ID", userId, QueryOP.EQUAL);
        queryFilter.addFilter("RECEIVE_LOGIN_NAME", userAccout, QueryOP.EQUAL);
        IPage<TaskAlreadyHandleHistoryVo> result = baseMapper.queryTaskWaitHandleHistory(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        List<TaskAlreadyHandleHistoryVo> records = result.getRecords();
        for (TaskAlreadyHandleHistoryVo record : records) {
            //巡检人ID RUMMAGER_ID_
            SiteInspectionVo siteInspectionVo = record.getSiteInspectionVo();
            String rummagerId = siteInspectionVo.getRummagerId();
            List<String> rummagerIds = Arrays.asList(rummagerId.split(","));
            QueryWrapper<User> userQueryWrapper = new QueryWrapper<>();
            userQueryWrapper.in("ID_",rummagerIds);
            List<User> users = userManager.getBaseMapper().selectList(userQueryWrapper);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < users.size(); i++) {
                User user = users.get(i);
                String fullname = user.getFullname();
                if (i==0) {
                    sb.append(fullname);
                }else {
                    sb.append(",").append(fullname);
                }
            }
            siteInspectionVo.setRummagerName(sb.toString());


            //记录人ID
            String recorderId = siteInspectionVo.getRecorderId();
            if (StringUtils.isNotEmpty(recorderId) ) {
                User recorderUser = this.userManager.getById(recorderId);
                siteInspectionVo.setRecorderName(recorderUser.getFullname());
            }
        }
        return new PageList<>(result);
    }

    @Override
    public PageList<TaskAlreadyHandleHistory> queryTaskWaitHandleLog(QueryFilter<TaskAlreadyHandleHistory> queryFilter) {
        IPage<TaskAlreadyHandleHistory> result =    this.baseMapper.queryTaskWaitHandleLog(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }
}
