package com.artfess.yhxt.specialproject.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 项目进度管理表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-11
 */
@ApiModel(value="BizProjectScheduleManagement对象", description="项目进度管理表")
@TableName("biz_project_schedule_management")
public class BizProjectScheduleManagement extends BizModel<BizProjectScheduleManagement> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "工程表id")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "工程表name")
    @TableField("PROJECT_NAME_")
    private String projectName;

    @ApiModelProperty(value = "项目开工表id")
    @TableField("STARTUP_ID_")
    private String startupId;

    @ApiModelProperty(value = "填报日期")
    @TableField("REPORT_DATE_")
    private String reportDate;

    @ApiModelProperty(value = "填报类型（1-日报、2-周报、3-月报）")
    @TableField("REPORT_TYPE_")
    private String reportType;

    @ApiModelProperty(value = "形象进度")
    @TableField("PROGRESS_RATIO_")
    private String progressRatio;

    @ApiModelProperty(value = "工程概况")
    @TableField("PROJECT_GENERAL_DESCRIPTION_")
    private String projectGeneralDescription;

    @ApiModelProperty(value = "本日/周/月工作")
    @TableField("WORK_CONTENT_")
    private String workContent;

    @ApiModelProperty(value = "进度描述")
    @TableField("PROGRESS_DESCRIPTION_")
    private String progressDescription;

    @ApiModelProperty(value = "工程变更情况")
    @TableField("PROGRAM_MODIFY_INFO_")
    private String programModifyInfo;

    @ApiModelProperty(value = "下步计划")
    @TableField("NEXT_STEP_PLAN_")
    private String nextStepPlan;

    @ApiModelProperty(value = "填报方")
    @TableField("REPORT_UNIT_")
    private String reportUnit;

    @ApiModelProperty(value = "1-有效（默认值）、0-无效")
    @TableField("VALID_FLAG_")
    private Integer validFlag;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getStartupId() {
        return startupId;
    }

    public void setStartupId(String startupId) {
        this.startupId = startupId;
    }

    public String getReportDate() {
        return reportDate;
    }

    public void setReportDate(String reportDate) {
        this.reportDate = reportDate;
    }

    public String getReportType() {
        return reportType;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    public String getProgressRatio() {
        return progressRatio;
    }

    public void setProgressRatio(String progressRatio) {
        this.progressRatio = progressRatio;
    }

    public String getProjectGeneralDescription() {
        return projectGeneralDescription;
    }

    public void setProjectGeneralDescription(String projectGeneralDescription) {
        this.projectGeneralDescription = projectGeneralDescription;
    }

    public String getWorkContent() {
        return workContent;
    }

    public void setWorkContent(String workContent) {
        this.workContent = workContent;
    }

    public String getProgressDescription() {
        return progressDescription;
    }

    public void setProgressDescription(String progressDescription) {
        this.progressDescription = progressDescription;
    }

    public String getProgramModifyInfo() {
        return programModifyInfo;
    }

    public void setProgramModifyInfo(String programModifyInfo) {
        this.programModifyInfo = programModifyInfo;
    }

    public String getNextStepPlan() {
        return nextStepPlan;
    }

    public void setNextStepPlan(String nextStepPlan) {
        this.nextStepPlan = nextStepPlan;
    }

    public String getReportUnit() {
        return reportUnit;
    }

    public void setReportUnit(String reportUnit) {
        this.reportUnit = reportUnit;
    }

    public Integer getValidFlag() {
        return validFlag;
    }

    public void setValidFlag(Integer validFlag) {
        this.validFlag = validFlag;
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizProjectScheduleManagement{" +
            "id=" + id +
            ", remarks=" + remarks +
            ", projectId=" + projectId +
            ", startupId=" + startupId +
            ", reportDate=" + reportDate +
            ", reportType=" + reportType +
            ", progressRatio=" + progressRatio +
            ", projectGeneralDescription=" + projectGeneralDescription +
            ", workContent=" + workContent +
            ", progressDescription=" + progressDescription +
            ", programModifyInfo=" + programModifyInfo +
            ", nextStepPlan=" + nextStepPlan +
            ", reportUnit=" + reportUnit +
            ", validFlag=" + validFlag +
            ", companyId=" + companyId +
            ", companyName=" + companyName +
        "}";
    }
}
