package com.artfess.yhxt.specialproject.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDate;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 合同信息变更待生效表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-12
 */
@ApiModel(value="BizContractChangeInvalid对象", description="合同信息变更待生效表")
@TableName("biz_contract_change_invalid")
public class BizContractChangeInvalid extends BizModel<BizContractChangeInvalid> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "合同表id")
    @TableField("CONTRACT_ID_")
    private String contractId;

    @ApiModelProperty(value = "项目id")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "路段id")
    @TableField("ROAD_SEGMENT_ID_")
    private String roadSegmentId;

    @ApiModelProperty(value = "路段NAME")
    @TableField("ROAD_SEGMENT_NAME_")
    private String roadSegmentName;

    @ApiModelProperty(value = "主管单位id")
    @TableField("OFFICE_ID_")
    private String officeId;

    @ApiModelProperty(value = "合同名称")
    @TableField("CONTRACT_NAME_")
    private String contractName;

    @ApiModelProperty(value = "合同类型")
    @TableField("CONTRACT_TYPE_")
    private String contractType;

    @ApiModelProperty(value = "第一方（甲方）")
    @TableField("FIRST_PARTY_")
    private String firstParty;

    @ApiModelProperty(value = "第二方（乙方）")
    @TableField("SECOND_PARTY_")
    private String secondParty;

    @ApiModelProperty(value = "第三方（丙方）")
    @TableField("THIRD_PARTY_")
    private String thirdParty;

    @ApiModelProperty(value = "合同编号")
    @TableField("CONTRACT_NUMBER_")
    private String contractNumber;

    @ApiModelProperty(value = "唯一编号")
    @TableField("UNIQUE_NUMBER_")
    private String uniqueNumber;

    @ApiModelProperty(value = "分类编号")
    @TableField("CLASSIFICATION_NUMBER_")
    private String classificationNumber;

    @ApiModelProperty(value = "发起人（立项人）")
    @TableField("CONTRACT_INITIATOR_")
    private String contractInitiator;

    @ApiModelProperty(value = "合同金额")
    @TableField("CONTRACT_AMOUNT_")
    private String contractAmount;

    @ApiModelProperty(value = "保证金")
    @TableField("RETENTION_MONEY_")
    private String retentionMoney;

    @ApiModelProperty(value = "结算金额")
    @TableField("SETTLEMENT_AMOUNT_")
    private String settlementAmount;

    @ApiModelProperty(value = "合同日期（签约日期）")
    @TableField("CONTRACT_DATE_")
    private LocalDate contractDate;

    @ApiModelProperty(value = "合同内容")
    @TableField("CONTRACT_CONTENTS_")
    private String contractContents;

    @ApiModelProperty(value = "单位确定方式")
    @TableField("CONFIRMATION_MODE_")
    private String confirmationMode;

    @ApiModelProperty(value = "1-有效（默认值）、0-无效")
    @TableField("VALID_FLAG_")
    private Integer validFlag;

    @ApiModelProperty(value = "正式变更待生效表业务主键")
    @TableField("CHANGE_EXECUTE_ID_")
    private String changeExecuteId;

    @ApiModelProperty(value = "正式变更是否已生效（1-已生效、0-未生效）")
    @TableField("CHANGE_CONFIRM_STATUS_")
    private Integer changeConfirmStatus;

    @ApiModelProperty(value = "正式变更待生效数据是否有效（1-有效、0-无效）")
    @TableField("CHANGE_VALID_FLAG_")
    private Integer changeValidFlag;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getContractId() {
        return contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }
    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    public String getRoadSegmentId() {
        return roadSegmentId;
    }

    public void setRoadSegmentId(String roadSegmentId) {
        this.roadSegmentId = roadSegmentId;
    }
    public String getOfficeId() {
        return officeId;
    }

    public void setOfficeId(String officeId) {
        this.officeId = officeId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }
    public String getFirstParty() {
        return firstParty;
    }

    public void setFirstParty(String firstParty) {
        this.firstParty = firstParty;
    }
    public String getSecondParty() {
        return secondParty;
    }

    public void setSecondParty(String secondParty) {
        this.secondParty = secondParty;
    }
    public String getThirdParty() {
        return thirdParty;
    }

    public void setThirdParty(String thirdParty) {
        this.thirdParty = thirdParty;
    }
    public String getContractNumber() {
        return contractNumber;
    }

    public void setContractNumber(String contractNumber) {
        this.contractNumber = contractNumber;
    }
    public String getUniqueNumber() {
        return uniqueNumber;
    }

    public void setUniqueNumber(String uniqueNumber) {
        this.uniqueNumber = uniqueNumber;
    }
    public String getClassificationNumber() {
        return classificationNumber;
    }

    public void setClassificationNumber(String classificationNumber) {
        this.classificationNumber = classificationNumber;
    }
    public String getContractInitiator() {
        return contractInitiator;
    }

    public void setContractInitiator(String contractInitiator) {
        this.contractInitiator = contractInitiator;
    }
    public String getContractAmount() {
        return contractAmount;
    }

    public void setContractAmount(String contractAmount) {
        this.contractAmount = contractAmount;
    }
    public String getRetentionMoney() {
        return retentionMoney;
    }

    public void setRetentionMoney(String retentionMoney) {
        this.retentionMoney = retentionMoney;
    }
    public String getSettlementAmount() {
        return settlementAmount;
    }

    public void setSettlementAmount(String settlementAmount) {
        this.settlementAmount = settlementAmount;
    }
    public LocalDate getContractDate() {
        return contractDate;
    }

    public void setContractDate(LocalDate contractDate) {
        this.contractDate = contractDate;
    }
    public String getContractContents() {
        return contractContents;
    }

    public void setContractContents(String contractContents) {
        this.contractContents = contractContents;
    }
    public String getConfirmationMode() {
        return confirmationMode;
    }

    public void setConfirmationMode(String confirmationMode) {
        this.confirmationMode = confirmationMode;
    }
    public Integer getValidFlag() {
        return validFlag;
    }

    public void setValidFlag(Integer validFlag) {
        this.validFlag = validFlag;
    }
    public String getChangeExecuteId() {
        return changeExecuteId;
    }

    public void setChangeExecuteId(String changeExecuteId) {
        this.changeExecuteId = changeExecuteId;
    }
    public Integer getChangeConfirmStatus() {
        return changeConfirmStatus;
    }

    public void setChangeConfirmStatus(Integer changeConfirmStatus) {
        this.changeConfirmStatus = changeConfirmStatus;
    }
    public Integer getChangeValidFlag() {
        return changeValidFlag;
    }

    public void setChangeValidFlag(Integer changeValidFlag) {
        this.changeValidFlag = changeValidFlag;
    }
    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getRoadSegmentName() {
        return roadSegmentName;
    }

    public void setRoadSegmentName(String roadSegmentName) {
        this.roadSegmentName = roadSegmentName;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizContractChangeInvalid{" +
            "id=" + id +
            ", contractId=" + contractId +
            ", projectId=" + projectId +
            ", remarks=" + remarks +
            ", roadSegmentId=" + roadSegmentId +
            ", officeId=" + officeId +
            ", contractName=" + contractName +
            ", contractType=" + contractType +
            ", firstParty=" + firstParty +
            ", secondParty=" + secondParty +
            ", thirdParty=" + thirdParty +
            ", contractNumber=" + contractNumber +
            ", uniqueNumber=" + uniqueNumber +
            ", classificationNumber=" + classificationNumber +
            ", contractInitiator=" + contractInitiator +
            ", contractAmount=" + contractAmount +
            ", retentionMoney=" + retentionMoney +
            ", settlementAmount=" + settlementAmount +
            ", contractDate=" + contractDate +
            ", contractContents=" + contractContents +
            ", confirmationMode=" + confirmationMode +
            ", validFlag=" + validFlag +
            ", changeExecuteId=" + changeExecuteId +
            ", changeConfirmStatus=" + changeConfirmStatus +
            ", changeValidFlag=" + changeValidFlag +
            ", companyId=" + companyId +
            ", companyName=" + companyName +
        "}";
    }
}
