package com.artfess.yhxt.specialproject.manager.impl;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.specialproject.manager.BizEngineeringAccessoriesManager;
import com.artfess.yhxt.specialproject.model.BizEngineeringAccessories;
import com.artfess.yhxt.specialproject.model.ProjectAcceptance;
import com.artfess.yhxt.specialproject.dao.ProjectAcceptanceDao;
import com.artfess.yhxt.specialproject.manager.ProjectAcceptanceManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.yhxt.specialproject.vo.ProjectAcceptanceVo;
import com.artfess.yhxt.specialproject.vo.ProjectOverApplyForVo;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 服务实现类
 *
 * @author xzh
 * @company 阿特菲斯信息技术有限公司
 * @since 2021-08-19
 */
@Service
public class ProjectAcceptanceManagerImpl extends BaseManagerImpl<ProjectAcceptanceDao, ProjectAcceptance> implements ProjectAcceptanceManager {
    @Resource
    private BizEngineeringAccessoriesManager engineeringAccessoriesManager;

    @Override
    public PageList<ProjectAcceptance> queryProjectAcceptance(QueryFilter<ProjectAcceptance> queryFilter) {
        IPage<ProjectAcceptance> result = baseMapper.queryProjectAcceptance(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);

    }

    @Override
    public BizEngineeringAccessories minioAcceptanceUpload(MultipartFile file, String sourceId) {

        return engineeringAccessoriesManager.minIoUpload(file, "acceptance", "", "yhxt", sourceId);
    }

    @Override
    public void minioAcceptanceDel(List<String> list) {
        if (list.size() > 0) {
            list.stream().forEach(s -> {
                engineeringAccessoriesManager.minIoRemoveFile(s, "acceptance", "yhxt");
            });
        }
    }

    @Override
    public void minIoAcceptanceDownFile(String ids, HttpServletResponse response) throws Exception {
        engineeringAccessoriesManager.minIoDownFile(ids, "acceptance", "download/acceptance", "yhxt", response);
    }

    @Override
    public void saveVo(ProjectAcceptanceVo projectAcceptanceVo) {
        ProjectAcceptance projectAcceptance = projectAcceptanceVo.getProjectAcceptance();
        this.create(projectAcceptance);
        //附件
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = projectAcceptanceVo.getBizEngineeringAccessoriesList();

        String sourceId = projectAcceptance.getId();
        bizEngineeringAccessoriesList.forEach(s -> {
            s.setSourceId(sourceId);
            s.setValidFlag(1);
        });
        this.engineeringAccessoriesManager.saveOrUpdateBatch(bizEngineeringAccessoriesList);
    }

    @Override
    public void updateVo(ProjectAcceptanceVo projectAcceptanceVo) {
        ProjectAcceptance projectAcceptance = projectAcceptanceVo.getProjectAcceptance();
        this.update(projectAcceptance);
        String sourceId = projectAcceptance.getId();
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = projectAcceptanceVo.getBizEngineeringAccessoriesList();
        engineeringAccessoriesManager.removeEngineeringAccessories(sourceId);
        bizEngineeringAccessoriesList.forEach(s -> {
            s.setSourceId(sourceId);
            s.setValidFlag(1);
        });
        this.engineeringAccessoriesManager.saveOrUpdateBatch(bizEngineeringAccessoriesList);
    }

    @Override
    public ProjectAcceptanceVo getVo(String id) {
        ProjectAcceptanceVo projectAcceptanceVo = new ProjectAcceptanceVo();
        ProjectAcceptance acceptance = this.getById(id);
        projectAcceptanceVo.setProjectAcceptance(acceptance);
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = this.engineeringAccessoriesManager.getEngineeringAccessoriesBySourceId(id);
        projectAcceptanceVo.setBizEngineeringAccessoriesList(bizEngineeringAccessoriesList);
        return projectAcceptanceVo;
    }
}
