package com.artfess.yhxt.specialproject.manager.impl;

import com.artfess.poi.util.ExcelUtil;
import com.artfess.yhxt.basedata.manager.AccessoryManager;
import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.yhxt.specialproject.manager.BizEngineeringProjectManager;
import com.artfess.yhxt.specialproject.manager.BizProjectContractManager;
import com.artfess.yhxt.specialproject.manager.MeasurementPaymentDetailsManager;
import com.artfess.yhxt.specialproject.model.BizEngineeringProject;
import com.artfess.yhxt.specialproject.model.BizProjectContract;
import com.artfess.yhxt.specialproject.model.MeasurementPayment;
import com.artfess.yhxt.specialproject.dao.MeasurementPaymentDao;
import com.artfess.yhxt.specialproject.manager.MeasurementPaymentManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.yhxt.specialproject.model.MeasurementPaymentDetails;
import com.artfess.yhxt.specialproject.params.ConstructionParamVo;
import com.artfess.yhxt.specialproject.vo.BizProjectWeeklyMonthlyReportVo;
import com.artfess.yhxt.specialproject.vo.MeasurementPaymentVo;
import com.artfess.yhxt.util.ExcelToPdfUtil;
import com.artfess.yhxt.util.PoiStyleUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 专项工程-计量支付 服务实现类
 *
 * @author xmz
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-06-29
 */
@Service
public class MeasurementPaymentManagerImpl extends BaseManagerImpl<MeasurementPaymentDao, MeasurementPayment> implements MeasurementPaymentManager {

    @Value("${pdfUrl}")
    private String pdfUrl;
    @Resource
    private MeasurementPaymentDetailsManager measurementPaymentDetailsManager;
    //项目管理
    @Resource
    private BizEngineeringProjectManager bizEngineeringProjectManager;
    //合同
    @Resource
    private BizProjectContractManager bizProjectContractManager;

    @Resource
    private AccessoryManager accessoryManager;

    @Override
    public MeasurementPaymentVo getVoById(String id) {
        MeasurementPaymentVo vo = new MeasurementPaymentVo();
        MeasurementPayment measurementPayment = this.getById(id);
        if (measurementPayment!=null){
            vo.setMeasurementPayment(measurementPayment);
            List<Accessory> accessories = accessoryManager.getAccessoryBySourceId(measurementPayment.getId());
            vo.setFiles(accessories);
        }
        return vo;
    }

    @Override
    public void saveVo(MeasurementPaymentVo vo) {
        MeasurementPayment measurementPayment = vo.getMeasurementPayment();
        List<MeasurementPaymentDetails> details = vo.getDetails();
        this.create(measurementPayment);
        if (CollectionUtils.isNotEmpty(details)) {
            details.forEach(s -> s.setMeasurementPaymentId(measurementPayment.getId()));
            measurementPaymentDetailsManager.saveBatch(details);
        }

        //删除原来的附件信息
        this.accessoryManager.delAccessoryBySourceId(measurementPayment.getId());
        List<Accessory> accessoryWorkOrderList = vo.getFiles();
        if (null != accessoryWorkOrderList && accessoryWorkOrderList.size() > 0) {
            //设置附件资源ID
            accessoryWorkOrderList.forEach(s -> {
                s.setSourceId(measurementPayment.getId());
                s.setGroup("payment");
            });
            this.accessoryManager.saveBatch(accessoryWorkOrderList);
        }
    }

    @Override
    public void updateVo(MeasurementPaymentVo vo) {
        MeasurementPayment measurementPayment = vo.getMeasurementPayment();
        List<MeasurementPaymentDetails> details = vo.getDetails();
        this.update(measurementPayment);
        //删除原来的数据
        boolean b = this.measurementPaymentDetailsManager.remove(new LambdaQueryWrapper<MeasurementPaymentDetails>().eq(MeasurementPaymentDetails::getMeasurementPaymentId, measurementPayment.getId()));
        if (b) {
            if (CollectionUtils.isNotEmpty(details)) {
                this.measurementPaymentDetailsManager.saveBatch(details);
            }
        }
        //删除原来的附件信息
        this.accessoryManager.delAccessoryBySourceId(measurementPayment.getId());
        List<Accessory> accessoryWorkOrderList = vo.getFiles();
        if (null != accessoryWorkOrderList && accessoryWorkOrderList.size() > 0) {
            //设置附件资源ID
            accessoryWorkOrderList.forEach(s -> {
                s.setSourceId(measurementPayment.getId());
                s.setGroup("payment");
            });
            this.accessoryManager.saveBatch(accessoryWorkOrderList);
        }

    }

    @Override
    public boolean removeVo(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        boolean b = this.removeByIds(idList);

        if (b) {
            boolean result = this.measurementPaymentDetailsManager.remove(new LambdaQueryWrapper<MeasurementPaymentDetails>().in(MeasurementPaymentDetails::getMeasurementPaymentId, idList));
            return b;
        }
        return false;
    }

    @Override
    public HSSFWorkbook exportConstruction(ConstructionParamVo param, HttpServletResponse response) throws Exception {
        HSSFWorkbook workbook = new HSSFWorkbook();
        //项目id
        String projectId = param.getProjectId();

        //项目合同id
        String projectContractId = param.getProjectContractId();
        //合同信息
//        List<BizProjectContract> list = bizProjectContractManager.list(new LambdaQueryWrapper<BizProjectContract>().eq(BizProjectContract::getProjectId, projectId));
        BizProjectContract bizProjectContract = new BizProjectContract();
        if (StringUtils.isNotEmpty(projectContractId)) {
            bizProjectContract = bizProjectContractManager.getById(projectContractId);
        }
        //项目
        BizEngineeringProject bizEngineeringProject = bizEngineeringProjectManager.getBaseMapper().selectById(projectId);
        //根据合同ID和项目ID查询计量支付
        List<MeasurementPayment> list = this.list(new LambdaQueryWrapper<MeasurementPayment>().eq(MeasurementPayment::getProjectId, projectId).eq(MeasurementPayment::getProjectContractId, projectContractId));
        List<MeasurementPaymentDetails> paymentDetails = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            for (MeasurementPayment measurementPayment : list) {
                List<MeasurementPaymentDetails> details = measurementPaymentDetailsManager.list(new LambdaQueryWrapper<MeasurementPaymentDetails>().eq(MeasurementPaymentDetails::getMeasurementPaymentId, measurementPayment.getId()));
                paymentDetails.addAll(details);
            }
        }

        //标题样式
        HSSFCellStyle cellStyleTitle = workbook.createCellStyle();
        //内容样式1
        HSSFCellStyle cellStyle1 = workbook.createCellStyle();
        //内容样式2
        HSSFCellStyle cellStyle2 = workbook.createCellStyle();
        //内容样式3
        HSSFCellStyle cellStyle3 = workbook.createCellStyle();
        HSSFCellStyle cellStyle4 = workbook.createCellStyle();
        PoiStyleUtil.setWorkOrderStyleTitle(cellStyleTitle, workbook);
        PoiStyleUtil.setWorkOrderCellStyle1(cellStyle1, workbook);
        PoiStyleUtil.setWorkOrderCellStyle2(cellStyle2, workbook);
        PoiStyleUtil.setWorkOrderCellStyle3(cellStyle3, workbook);
        PoiStyleUtil.setWorkOrderCellStyle4(cellStyle4, workbook);
        HSSFSheet sheet = workbook.createSheet("工程收方记录表（施工类）");
        sheet.getPrintSetup().setPaperSize(HSSFPrintSetup.A4_PAPERSIZE);
        //设置横向
        sheet.getPrintSetup().setLandscape(true);
        List<List<MeasurementPaymentDetails>> collect = Stream.iterate(0, f -> f + 1).limit((paymentDetails.size() + 9) / 10).parallel().map(a -> paymentDetails.stream().skip(a * 10).limit(10).parallel().collect(Collectors.toList())).collect(Collectors.toList());
        sheet.setColumnWidth(0, 10 * 256);
        sheet.setColumnWidth(1, 20 * 256);
        sheet.setColumnWidth(2, 20 * 256);
        sheet.setColumnWidth(3, 20 * 256);
        sheet.setColumnWidth(4, 8 * 256);
        sheet.setColumnWidth(5, 8 * 256);
        sheet.setColumnWidth(6, 8 * 256);
        sheet.setColumnWidth(7, 10 * 256);
        sheet.setColumnWidth(8, 10 * 256);
        sheet.setColumnWidth(9, 10 * 256);
        if (StringUtils.isEmpty(projectContractId)) {
            defaultExportConstruction(cellStyleTitle, cellStyle1,cellStyle2,cellStyle3,cellStyle4, sheet, bizEngineeringProject);
        } else if (CollectionUtils.isEmpty(paymentDetails)) {
            exportPayMentDetails(bizProjectContract, bizEngineeringProject, list, cellStyleTitle, cellStyle1, cellStyle2, cellStyle3,cellStyle4,  sheet);
        } else {
            int num = 0;
            for (List<MeasurementPaymentDetails> measurementPaymentDetails : collect) {
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyleTitle, num, 0, "中国铁建昆仑集团重庆运营总部\n" +
                        "工程收方记录表（施工类）");
                sheet.addMergedRegion(new CellRangeAddress(num, num, 0, 9));
                num++;
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, num, 0, "工程名称（承包合同号/项目编号）：" + bizEngineeringProject.getProjectName());
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, num, 6, "表格编：" + (CollectionUtils.isNotEmpty(list) ? list.get(0).getRecordNumber() : ""));
                sheet.addMergedRegion(new CellRangeAddress(num, num, 0, 6));
                sheet.addMergedRegion(new CellRangeAddress(num, num, 6, 9));
                num++;
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, num, 0, "对方单位：");
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, num, 6, "合同号/项目编号：" + bizProjectContract.getContractNumber());
                num++;
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, num, 0, "序号");
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, num, 1, "清单名称");
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, num, 2, "施工/收方日期");
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, num, 3, "工程部位及桩号");
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, num, 4, "收方示意图/计算式");
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, num, 7, "单位");
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, num, 8, "数量");
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, num, 9, "备注");
                for (int i = 0; i < measurementPaymentDetails.size(); i++) {
                    MeasurementPaymentDetails paymentDetail = measurementPaymentDetails.get(i);
                    PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, num + i, 0, String.valueOf(i + 1));
                    PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, num + i, 1, paymentDetail.getSubjectName());
                    PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, num + i, 2, paymentDetail.getCommencementDate()==null?"":paymentDetail.getCommencementDate().toString());
                    PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, num + i, 3, paymentDetail.getCalculaMethod());
                    PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, num + i, 4,  paymentDetail.getCalculaMethod());
                    PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, num + i, 7, paymentDetail.getSubjectUnit());
                    PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, num + i, 8, paymentDetail.getSubjectAmount()==null?"":paymentDetail.getSubjectAmount().toString());
                    PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, num + i, 9, paymentDetail.getRemark());
                    num++;
                }


                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle4, num, 0, "施工单位经办人：              监理工程师：          管理中心经办人：           总部业务部门经办人：");
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle4, num, 0, "施工单位项目负责人：                                管理中心负责人：           总部业务部门负责人：");
                num++;
            }

        }

        return workbook;

    }

    @Override
    public HashMap onlinePreviewConstruction(ConstructionParamVo param, HttpServletResponse response) throws Exception {
        HSSFWorkbook workbook = this.exportConstruction(param, response);
        String path = "./download/"+param.getProjectId();
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        //拼接处全路径
        String outUrl = path  + "/工程收方记录表-施工类.xls";
        String outUrlPdf = path  + "/工程收方记录表-施工类.pdf";
        FileOutputStream out = new FileOutputStream(outUrl);
        workbook.write(out);//写入磁盘
        ExcelToPdfUtil.excelToPdf(outUrl,outUrlPdf);
        String url =  pdfUrl+ param.getProjectId() + "/工程收方记录表-施工类.pdf";
        System.out.println(url);
        HashMap map = new HashMap();
        map.put("url",url);
        return map;
    }

    @Override
    public HSSFWorkbook exportCollect(ConstructionParamVo param, HttpServletResponse response) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        //项目id
        String projectId = param.getProjectId();

        //项目合同id
        String projectContractId = param.getProjectContractId();
        //合同信息
//        List<BizProjectContract> list = bizProjectContractManager.list(new LambdaQueryWrapper<BizProjectContract>().eq(BizProjectContract::getProjectId, projectId));
        BizProjectContract bizProjectContract = new BizProjectContract();
        if (StringUtils.isNotEmpty(projectContractId)) {
            bizProjectContract = bizProjectContractManager.getById(projectContractId);
        }
        //项目
        BizEngineeringProject bizEngineeringProject = bizEngineeringProjectManager.getBaseMapper().selectById(projectId);
        //根据合同ID和项目ID查询计量支付
        List<MeasurementPayment> list = this.list(new LambdaQueryWrapper<MeasurementPayment>().eq(MeasurementPayment::getProjectId, projectId).eq(MeasurementPayment::getProjectContractId, projectContractId));
        List<MeasurementPaymentDetails> paymentDetails = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            for (MeasurementPayment measurementPayment : list) {
                List<MeasurementPaymentDetails> details = measurementPaymentDetailsManager.list(new LambdaQueryWrapper<MeasurementPaymentDetails>().eq(MeasurementPaymentDetails::getMeasurementPaymentId, measurementPayment.getId()));
                paymentDetails.addAll(details);
            }
        }

        //标题样式
        HSSFCellStyle cellStyleTitle = workbook.createCellStyle();
        //内容样式1
        HSSFCellStyle cellStyle1 = workbook.createCellStyle();
        //内容样式2
        HSSFCellStyle cellStyle2 = workbook.createCellStyle();
        //内容样式3
        HSSFCellStyle cellStyle3 = workbook.createCellStyle();
        HSSFCellStyle cellStyle4 = workbook.createCellStyle();
        PoiStyleUtil.setWorkOrderStyleTitle(cellStyleTitle, workbook);
        PoiStyleUtil.setWorkOrderCellStyle1(cellStyle1, workbook);
        PoiStyleUtil.setWorkOrderCellStyle2(cellStyle2, workbook);
        PoiStyleUtil.setWorkOrderCellStyle3(cellStyle3, workbook);
        PoiStyleUtil.setWorkOrderCellStyle4(cellStyle4, workbook);
        HSSFSheet sheet = workbook.createSheet("工程量汇总表");
        sheet.getPrintSetup().setPaperSize(HSSFPrintSetup.A4_PAPERSIZE);
        //设置横向
        sheet.getPrintSetup().setLandscape(true);
        List<List<MeasurementPaymentDetails>> collect = Stream.iterate(0, f -> f + 1).limit((paymentDetails.size() + 9) / 10).parallel().map(a -> paymentDetails.stream().skip(a * 10).limit(10).parallel().collect(Collectors.toList())).collect(Collectors.toList());
        sheet.setColumnWidth(0, 10 * 256);
        sheet.setColumnWidth(1, 20 * 256);
        sheet.setColumnWidth(2, 20 * 256);
        sheet.setColumnWidth(3, 20 * 256);
        sheet.setColumnWidth(4, 15 * 256);
        sheet.setColumnWidth(5, 15 * 256);
        sheet.setColumnWidth(6, 15 * 256);

        if (StringUtils.isEmpty(projectContractId)) {
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyleTitle, 0, 0, "中国铁建昆仑集团重庆运营总部\n" +
                    "工程量汇总表");
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 6));
            PoiStyleUtil.sheetSetHight(sheet, 0, 50);
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle1, 1, 0, "计量期数：第（ ）期");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle1, 1, 6, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle1, 1, 1, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle1, 1, 2, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle1, 1, 3, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle1, 1, 4, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle1, 1, 5, "");

            PoiStyleUtil.sheetSetHight(sheet, 1, 20);
            sheet.addMergedRegion(new CellRangeAddress(1, 1, 0, 6));

            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 0, "工程名称（承包合同号/项目编号）："+bizEngineeringProject.getProjectName());
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 5, "表格编号：");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 1, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 2, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 3, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 4, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 6, "");
            sheet.addMergedRegion(new CellRangeAddress(2, 2, 0, 4));
            sheet.addMergedRegion(new CellRangeAddress(2, 2, 5, 6));
            PoiStyleUtil.sheetSetHight(sheet, 2, 20);
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 3, 0, "对方单位：：");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 3, 5, "合同号/项目编号：");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 3, 1, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 3, 2, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 3, 3, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 3, 4, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 3, 6, "");
            sheet.addMergedRegion(new CellRangeAddress(3, 3, 0, 4));
            sheet.addMergedRegion(new CellRangeAddress(3, 3, 5, 6));

            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4, 0, "序号");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4, 1, "清单名称");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4, 2, "单位");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4, 3, "数量");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4, 4, "……");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4, 5, "收方记录表编号");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4, 6, "备注");

            PoiStyleUtil.sheetSetHight(sheet, 4, 20);

            for (int i = 0; i < 10; i++) {
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 5 + i, 0, String.valueOf(i + 1));
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 5 + i, 1, "");
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 5 + i, 2, "");
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 5 + i, 3, "");
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 5 + i, 4, "");
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 5 + i, 5, "");
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 5 + i, 6, "");

                PoiStyleUtil.sheetSetHight(sheet, 5+i, 30);

            }

            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle4, 15, 0, "施工单位经办人：                                 监理工程师：                           管理中心经办人：              总部业务部门经办人：");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle4, 16, 0, "施工单位项目负责人：                             总监理工程师：                          管理中心负责人：              总部业务部门负责人：");
            PoiStyleUtil.sheetSetHight(sheet, 15, 20);
            PoiStyleUtil.sheetSetHight(sheet, 16, 20);
            sheet.addMergedRegion(new CellRangeAddress(15, 15, 0, 6));
            sheet.addMergedRegion(new CellRangeAddress(16, 16, 0, 6));
        } else if (CollectionUtils.isEmpty(paymentDetails)) {

        }
        return workbook;
    }

    @Override
    public HashMap onlinePreviewCollect(ConstructionParamVo param, HttpServletResponse response) throws Exception {
        HSSFWorkbook workbook = this.exportCollect(param, response);
        String path = "./download/"+param.getProjectId();
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        //拼接处全路径
        String outUrl = path  + "/工程收方汇总表.xls";
        String outUrlPdf = path  + "/工程收方汇总表.pdf";
        FileOutputStream out = new FileOutputStream(outUrl);
        workbook.write(out);//写入磁盘
        ExcelToPdfUtil.excelToPdf(outUrl,outUrlPdf);
        String url =  pdfUrl+ param.getProjectId() + "/工程收方记录表-施工类.pdf";
        System.out.println(url);
        HashMap map = new HashMap();
        map.put("url",url);
        return map;
    }

    //只有合同信息
    private void exportPayMentDetails(BizProjectContract bizProjectContract, BizEngineeringProject bizEngineeringProject, List<MeasurementPayment> list, HSSFCellStyle cellStyleTitle,
                                      HSSFCellStyle cellStyle1,
                                      HSSFCellStyle cellStyle2,
                                      HSSFCellStyle cellStyle3,
                                      HSSFCellStyle cellStyle4,
                                      HSSFSheet sheet) {
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyleTitle, 0, 0, "中国铁建昆仑集团重庆运营总部\n" +
                "工程收方记录表（施工类）");
        PoiStyleUtil.sheetSetHight(sheet, 0, 50);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 9));
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 1, 0, "工程名称（承包合同号/项目编号）：" + bizEngineeringProject.getProjectName());
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 1, 6, "表格编：" + (CollectionUtils.isNotEmpty(list) ? list.get(0).getRecordNumber() : ""));
        PoiStyleUtil.sheetSetHight(sheet, 1, 20);
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 0, "对方单位：");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 6, "合同号/项目编号：" + bizProjectContract.getContractNumber());
        PoiStyleUtil.sheetSetHight(sheet, 2, 20);
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 0, 5));
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 6, 9));
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 0, "序号");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 1, "清单名称");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 2, "施工/收方日期");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 3, "工程部位及桩号");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 4, "收方示意图/计算式");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 5, "");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 6, "");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 7, "单位");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 8, "数量");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 9, "备注");
        PoiStyleUtil.sheetSetHight(sheet, 3, 20);
        sheet.addMergedRegion(new CellRangeAddress(3, 3, 4, 6));
        for (int i = 0; i < 10; i++) {
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 0, String.valueOf(i + 1));
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 1, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 2, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 3, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 4, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 5, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 6, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 7, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 8, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 9, "");
            PoiStyleUtil.sheetSetHight(sheet, 4+i, 30);
            sheet.addMergedRegion(new CellRangeAddress(4 + i, 4 + i, 4, 6));

        }

        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle4, 14, 0, "施工单位经办人：                            监理工程师：                            管理中心经办人：                    总部业务部门经办人：");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle4, 15, 0, "施工单位项目负责人：                                                                管理中心负责人：           总部业务部门负责人：");
        PoiStyleUtil.sheetSetHight(sheet, 14, 20);
        PoiStyleUtil.sheetSetHight(sheet, 15, 20);
        sheet.addMergedRegion(new CellRangeAddress(14, 14, 0, 9));
        sheet.addMergedRegion(new CellRangeAddress(15, 15, 0, 9));

    }

    //只有项目信息
    private void defaultExportConstruction(HSSFCellStyle cellStyleTitle,
                                           HSSFCellStyle cellStyle1,
                                           HSSFCellStyle cellStyle2,
                                           HSSFCellStyle cellStyle3,
                                           HSSFCellStyle cellStyle4,
                                           HSSFSheet sheet, BizEngineeringProject bizEngineeringProject) {
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyleTitle, 0, 0, "中国铁建昆仑集团重庆运营总部工程收方记录表（施工类）");
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 9));
        PoiStyleUtil.sheetSetHight(sheet, 0, 50);
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 1, 0, "工程名称（承包合同号/项目编号）：" + bizEngineeringProject.getProjectName());
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 1, 6, "表格编：");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 1, 1, "");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 1, 2, "");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 1, 3, "");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 1, 4, "");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 1, 5, "");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 1, 7, "");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 1, 8, "");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 1, 9, "");
        PoiStyleUtil.sheetSetHight(sheet, 1, 20);
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 0, 5));
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 6, 9));

        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 0, "对方单位：");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 6, "合同号/项目编号：");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 1, "");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 2, "");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 3, "");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 4, "");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 5, "");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 7, "");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 8, "");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 9, "");
        PoiStyleUtil.sheetSetHight(sheet, 2, 20);
        sheet.addMergedRegion(new CellRangeAddress(2, 2, 0, 5));
        sheet.addMergedRegion(new CellRangeAddress(2, 2, 6, 9));
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 0, "序号");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 1, "清单名称");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 2, "施工/收方日期");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 3, "工程部位及桩号");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 4, "收方示意图/计算式");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 5, "收方示意图/计算式");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 6, "收方示意图/计算式");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 7, "单位");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 8, "数量");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 9, "备注");
        PoiStyleUtil.sheetSetHight(sheet, 3, 20);
        sheet.addMergedRegion(new CellRangeAddress(3, 3, 4, 6));

        for (int i = 0; i < 10; i++) {
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 0, String.valueOf(i + 1));
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 1, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 2, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 3, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 4, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 5, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 6, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 7, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 8, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 9, "");
            PoiStyleUtil.sheetSetHight(sheet, 4+i, 30);
            sheet.addMergedRegion(new CellRangeAddress(4 + i, 4 + i, 4, 6));
        }

        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle4, 14, 0, "施工单位经办人：                            监理工程师：                            管理中心经办人：                    总部业务部门经办人：");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle4, 15, 0, "施工单位项目负责人：                                                                管理中心负责人：           总部业务部门负责人：");
        PoiStyleUtil.sheetSetHight(sheet, 14, 20);
        PoiStyleUtil.sheetSetHight(sheet, 15, 20);
        sheet.addMergedRegion(new CellRangeAddress(14, 14, 0, 9));
        sheet.addMergedRegion(new CellRangeAddress(15, 15, 0, 9));
    }
}
