package com.artfess.yhxt.specialproject.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.specialproject.model.BizEngineeringProject;
import com.artfess.base.manager.BaseManager;
import com.artfess.yhxt.specialproject.model.BizProjectContract;
import com.artfess.yhxt.specialproject.vo.BizEngineeringProjectVo;
import com.artfess.yhxt.specialproject.vo.ProjectMoneyListVO;
import com.artfess.yhxt.specialproject.vo.ProjectMoneyVO;
import com.artfess.yhxt.specialproject.vo.ProjectReportVO;
import com.artfess.yhxt.statistics.vo.Org4DiseaseVO;
import com.artfess.yhxt.statistics.vo.Org4ProjectMoneyVO;
import com.artfess.yhxt.statistics.vo.Org4ProjectVO;

import java.util.List;

/**
 * 工程项目表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-10
 */
public interface BizEngineeringProjectManager extends BaseManager<BizEngineeringProject> {

    PageList<BizEngineeringProject> queryBizEngineeringProject(QueryFilter<BizEngineeringProject> queryFilter);

    BizEngineeringProject getBizEngineeringProjectById(String id);

    void updateFlag(String ids, Integer flag);

    /**
     * 保存工程项目、附件信息
     * @param bizEngineeringProjectVo
     */
    void saveVo(BizEngineeringProjectVo bizEngineeringProjectVo);

    /**
     * 修改
     * @param bizEngineeringProjectVo
     */
    void updateVo(BizEngineeringProjectVo bizEngineeringProjectVo);

    BizEngineeringProjectVo getVo(String id);

    List<Org4ProjectVO> getProjectCount(String year);

    List<ProjectReportVO> getReport(String year,String orgId);

    List<ProjectMoneyVO> getMoneyReport(String year, String orgId);

    List<ProjectMoneyListVO> getMoneyListReport(String year, String orgId);

    List<Org4ProjectMoneyVO> getProjectMoneyCount(String year);
}
