package com.artfess.yhxt.contract.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@Data
public class OrderCashVo {

    @ApiModelProperty("运营管理单位")
    @Excel(name = "运营管理单位" ,width =20)
    private String companyName;


    @ApiModelProperty(value = "所属年限")
    private Integer ascriptionYear;


    @ApiModelProperty("路段名称")
    @Excel(name = "路段名称" ,width =20)
    private String roadName;

    @ApiModelProperty("养护资金计划-日常")
    @Excel(name = "年度养护资金计划(日常)" ,width =20)
    private BigDecimal fundDaily;

    @ApiModelProperty("养护资金计划-专项")
    @Excel(name = "年度养护资金计划(专项)" ,width =20)
    private BigDecimal fundSpecial;

    @ApiModelProperty("养护资金计划-合计")
    @Excel(name = "年度养护资金计划(合计)" ,width =20)
    private BigDecimal fundTotal;


    @ApiModelProperty("养护资金计划执行情况-日常")
    @Excel(name = "养护资金计划执行情况(日常)" ,width =20)
    private BigDecimal fundDailyAbort;

    @ApiModelProperty("养护资金计划执行情况-专项")
    @Excel(name = "养护资金计划执行情况(专项)" ,width =20)
    private BigDecimal fundSpecialAbort;

    @ApiModelProperty("养护资金计划执行情况-合计")
    @Excel(name = "养护资金计划执行情况(合计)" ,width =20)
    private BigDecimal fundTotalAbort;


    @ApiModelProperty("完成年度百分比-日常")
    @Excel(name = "完成年度百分比(日常)" ,width =20)
    private String percentageDaily;

    @ApiModelProperty("完成年度百分比-专项")
    @Excel(name = "完成年度百分比(专项)" ,width =20)
    private String percentageSpecial;

    @ApiModelProperty("完成年度百分比-合计")
    @Excel(name = "完成年度百分比(合计)" ,width =20)
    private String percentageTotal;


}
