package com.artfess.yhxt.contract.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.contract.model.Contract;
import com.artfess.base.manager.BaseManager;
import com.artfess.yhxt.contract.vo.ContractVo;
import com.artfess.yhxt.contract.vo.WorkOrderParamVo;
import com.artfess.yhxt.statistics.vo.Org4ContractVO;
import com.artfess.yhxt.statistics.vo.Org4bridgeInfoVO;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;

/**
 * 合同表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 超级管理员
 * @since 2021-08-06
 */
public interface ContractManager extends BaseManager<Contract> {

    /**
     * 分页查询合同基本信息
     * @param queryFilter
     * @return
     */
    PageList<Contract> queryContract(QueryFilter<Contract> queryFilter);

    /**
     * 保存合同信息
     * @param vo
     */
    String saveContractVo(ContractVo vo);

    /**
     * 修改合同信息
     * @param vo
     */
    String updateContractVo(ContractVo vo);

    /**
     * 检查唯一编号
     */
    void checkUniqueNumber(Contract contract);

    /**
     * 上传合同附件
     * @param file
     * @param sourceId
     */
    String minioContractUpload(MultipartFile file, String sourceId);

    /**
     *
     * @param ids
     * @param response
     * @throws IOException
     */
    void downloadContractUpload(String ids, HttpServletResponse response ) throws IOException;

    /**
     * 根据ID查询 合同信息
     * @param id
     * @return
     */
    ContractVo getContractById(String id);

    void minioContractDel(List<String> asList);

    List<Org4ContractVO> getContractCount(String year);
}
