package com.artfess.yhxt.contract.dao;

import com.artfess.base.query.PageBean;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.artfess.bpm.persistence.model.DefaultBpmTask;
import com.artfess.yhxt.contract.model.WorkOrderInformation;
import com.artfess.yhxt.contract.vo.OrderItemCountVo;
import com.artfess.yhxt.contract.vo.WorkOrderDiseaseVo;
import com.artfess.yhxt.contract.vo.WorkOrderVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 工单信息表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-20
 */
public interface WorkOrderInformationDao extends BaseMapper<WorkOrderInformation> {

    IPage<WorkOrderInformation> queryWorkOrderInformation(IPage<WorkOrderInformation> convert2IPage,@Param(Constants.WRAPPER) Wrapper<WorkOrderInformation> convert2Wrapper);

    IPage<WorkOrderVo> getWorkOrderVo(IPage<WorkOrderInformation> convert2IPage,
                                      @Param("map") Map<String, Object> params,
                                      @Param(Constants.WRAPPER) Wrapper<WorkOrderInformation> convert2Wrapper);

    /**
     * 查询工单信息
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<WorkOrderDiseaseVo> getWorkOrderInformation(IPage<WorkOrderInformation> convert2IPage,
                                                      @Param("params") HashMap params,
                                                      @Param(Constants.WRAPPER)  Wrapper<WorkOrderInformation> convert2Wrapper);

    @Select("SELECT biz_key_ FROM bpm_pro_inst WHERE bpmn_inst_id_ = #{bpmnInstId}")
    String getBizkey(String bpmnInstId);

    @Select("SELECT * FROM bpm_pro_inst WHERE biz_key_ = #{bizKey}")
    List<DefaultBpmProcessInstance> selectBpmProInst(@Param("bizKey") String bizKey);

    @Select("SELECT * FROM bpm_task WHERE proc_inst_id_ = #{procInstId}")
    List<DefaultBpmTask> selectDefaultBpmTask(@Param("procInstId")  String procInstId);

    @Select("SELECT DISTINCT a.* FROM biz_work_order_information a INNER JOIN bpm_pro_inst b ON a.ID_ =b.biz_key_ AND ROAD_SEGMENT_ID_ = #{rodeSegmentId}  AND a.END_TIME_ BETWEEN #{first} AND #{last}")
    List<WorkOrderInformation> listFinishWork(@Param("rodeSegmentId") String rodeSegmentId,@Param("first") String first, @Param("last")String last);

    @Select("SELECT DISTINCT a.* FROM biz_work_order_information a INNER JOIN bpm_pro_inst b ON a.ID_ =b.biz_key_ AND ROAD_SEGMENT_ID_ = #{rodeSegmentId}  AND a.ISSUE_DATE_ BETWEEN #{first} AND #{last}")
    List<WorkOrderInformation> listWorkAll(@Param("rodeSegmentId") String rodeSegmentId,@Param("first") String first, @Param("last")String last);

    @Select("SELECT\n" +
            "\tSUM( AUDIT_MONEY_ ) \n" +
            "FROM\n" +
            "\tbiz_bill_of_quantities \n" +
            "WHERE\n" +
            "\tIS_DELE_ = 0 \n" +
            "\tAND WORK_ORDER_INFORMATION_ID_ = #{id}")
    Float selectSumMoney(@Param("id")String id);

    @Select("SELECT * FROM biz_work_order_information WHERE `STATUS_` = 0")
    List<WorkOrderInformation> selectOverdue();

    @Update("UPDATE biz_work_order_information \n" +
            "SET OVERDUE_ = 0 \n" +
            "WHERE\n" +
            "\tSTATUS_ = 1")
    void updateOverdue();

    IPage<WorkOrderVo> getWorkOrderVoList(IPage<WorkOrderInformation> convert2IPage,
                                      @Param("map") Map<String, Object> params,
                                      @Param(Constants.WRAPPER) Wrapper<WorkOrderInformation> convert2Wrapper);


    IPage<OrderItemCountVo> orderItemCountReport(IPage<WorkOrderInformation> convert2IPage,@Param(Constants.WRAPPER) Wrapper<WorkOrderInformation> convert2Wrapper);

}
