package com.artfess.yhxt.check.regular.dao;

import com.artfess.yhxt.check.regular.model.SideSlopeOftenCheck;
import com.artfess.yhxt.check.regular.model.TunnelOftenCheck;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.HashMap;
import java.util.Map;

/**
 * 边坡经常检查表 Mapper 接口
 *
 * @author 超级管理员
 * @company 阿特菲斯信息技术有限公司
 * @since 2021-08-05
 */
public interface SideSlopeOftenCheckDao extends BaseMapper<SideSlopeOftenCheck> {

    IPage<SideSlopeOftenCheck> querySideSlopeOftenCheck(IPage<SideSlopeOftenCheck> convert2IPage,
                                                        @Param("map") Map<String, Object> params,
                                                        @Param(Constants.WRAPPER) Wrapper<SideSlopeOftenCheck> convert2Wrapper);

    @Select("SELECT * FROM BIZ_SIDE_SLOPE_OFTEN_CHECK WHERE SIDE_SLOPE_ID_ = #{id}  ORDER BY CHECK_DATE_ DESC LIMIT 0,1")
    SideSlopeOftenCheck selectMaxcheckDate(String id);

    int countSideSlopeOften(@Param("ids") String sideSlopeIds, @Param("mouth") String mouth);
}
