package com.artfess.yhxt.check.regular.controller;


import com.alibaba.fastjson.JSON;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.FileUtil;
import com.artfess.yhxt.check.regular.manager.CulvertOftenCheckManager;
import com.artfess.yhxt.check.regular.model.CulvertOftenCheck;
import com.artfess.yhxt.check.regular.model.SideSlopeOftenCheck;
import com.artfess.yhxt.check.regular.model.TunnelOftenCheck;
import com.artfess.yhxt.check.regular.vo.CulvertOftenCheckVo;
import com.artfess.yhxt.check.regular.vo.SideSlopeOftenCheckVo;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;


/**
 * 涵洞经常检查表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-05
 */
@RestController
@RequestMapping("/culvertOftenCheck/v1/")
@Api(tags = "涵洞经常检查接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class CulvertOftenCheckController extends BaseController<CulvertOftenCheckManager, CulvertOftenCheck> {

    @RequestMapping(value="getJson",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询涵洞经常检查信息",httpMethod = "POST")
    public PageList<CulvertOftenCheck> getJson(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<CulvertOftenCheck> queryFilter) {
        queryFilter.addFilter("IS_DELE_", "0", QueryOP.EQUAL);
        PageList<CulvertOftenCheck> pageList = baseService.queryCulvertOftenCheck(queryFilter);
        return  pageList;
    }


    @RequestMapping(value = "saveCulvertOftenCheck", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存涵洞经常检查信息", httpMethod = "POST")
    public CommonResult<String> saveCulvertOftenCheck(@ApiParam(name = "vo", value = "经常检查vo") @RequestBody CulvertOftenCheckVo vo) throws Exception {
        String msg = "添加成功";
        this.baseService.saveCulvertOftenCheck(vo);
        return new CommonResult<String>(msg);
    }


    /**
     * 批量导入Excel数据
     *
     * @param file Excel文件
     */
    @PostMapping("/importExcelData")
    @ApiOperation(value = "Excel批量导入涵洞经常检查详情数据")
    public CommonResult importExcelData(
            @ApiParam("上传文件") @RequestParam("file") MultipartFile file,
            @ApiParam(name = "mainJson", value = "主数据JSON字符数据") @RequestParam("mainJson") String mainJson) {
        baseService.importExcelData(file, JSON.parseObject(mainJson, CulvertOftenCheck.class));
        return new CommonResult<>("导入成功");
    }

    /**
     * 下载导入模板
     *
     * @param response
     * @return
     */
    @ApiOperation(value = "下载导入模板")
    @GetMapping("/downModel")
    public void downTemplate(HttpServletResponse response) throws Exception {
        ClassPathResource classPathResource = new ClassPathResource("model/culvertOftenCheckDetial.xlsx");
        FileUtil.fileDownload(response, classPathResource.getInputStream(), "涵洞经常检查导入模板.xlsx");
    }

    @RequestMapping(value = "updateCulvertOftenCheck", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "修改涵洞经常检查信息", httpMethod = "POST")
    public CommonResult<String> updateCulvertOftenCheck(@ApiParam(name = "vo", value = "经常检查vo") @RequestBody CulvertOftenCheckVo vo) throws Exception {
        String msg = "修改成功";
        this.baseService.updateCulvertOftenCheck(vo);
        return new CommonResult<String>(msg);
    }


    @RequestMapping(value="get/{id}",method = RequestMethod.GET, produces={"application/json; charset=utf-8" })
    @ApiOperation(value="根据ID查询涵洞经常检查信息",httpMethod = "GET",notes = "根据ID查询涵洞经常检查信息")
    public CulvertOftenCheckVo get(@ApiParam(name="id",value="业务对象主键", required = true)@PathVariable String id) throws Exception{
        return baseService.getCulvertOftenCheckById(id);
    }

    @RequestMapping(value = "deleteCulvertOftenCheck", method = RequestMethod.DELETE, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "逻辑删除涵洞经常检查信息", httpMethod = "POST", notes = "逻辑删除涵洞经常检查信息")
    public CommonResult<String> deleteCulvertOftenCheck(@ApiParam(name = "ids", value = "可视化分类ID集合以，隔开", required = true)
                                                          @RequestParam(value = "ids", required = true) String ids) throws Exception {
        if (StringUtils.isNotBlank(ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<CulvertOftenCheck> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_", idsList);
            updateWrapper.set("is_dele_", "1");
            baseService.update(null, updateWrapper);
        }
        return new CommonResult<>(true, "删除成功");
    }
}
