package com.artfess.yhxt.statistics.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.bpm.persistence.manager.BpmTaskManager;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.Org;
import com.artfess.yhxt.statistics.dao.WorkbenchDao;
import com.artfess.yhxt.statistics.manager.WorkbenchManager;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author zhx
 * @create 2021/11/2
 */
@Service
public class WorkbenchManagerImpl implements WorkbenchManager {
    @Resource
    private BaseContext baseContext;
    @Resource
    private WorkbenchDao workbenchDao;
    @Resource
    private BpmTaskManager bpmTaskManager;

    @Resource
    private OrgManager orgManager;

    @Override
    public Map<String, Object> getWorkOrder() {
        //登录者ID
        String userId = baseContext.getCurrentUserId();
        //登录人账号
        String userAccout = baseContext.getCurrentUserAccout();
        //待处理工单
        Integer siteCount = this.workbenchDao.selectSiteCount(userId);
        //待处理病害
        Integer diseaseCount = this.workbenchDao.selectDiseaseCount(userId);
        //待办养护工单
       // this.workbenchDao.
        Long workOrderCount = bpmTaskManager.getTodoCountByUserId(baseContext.getCurrentUserId(), "");
        Map<String, Object> map = new HashMap<>();
        map.put("siteCount",siteCount);
        map.put("diseaseCount",diseaseCount);
        map.put("workOrderCount",workOrderCount);
        return map;
    }

    @Override
    public Map<String, Object> getOverdue() {
        //登录者ID
        String userId = baseContext.getCurrentUserId();
        //登录者公司ID
        String currentOrgId = baseContext.getCurrentOrgId();
        Map<String, Object> map = new HashMap<>();
        //病害即将逾期
        Long diseaseOverdueCount = this.workbenchDao.selectDiseaseOverdueCount(currentOrgId);
        //病害已逾期
        Long diseaseOverdueCountTrue = this.workbenchDao.selectDiseaseOverdueCountTrue(currentOrgId);
        //即将逾期养护工单
//        Long workOrderOverdueCount =  this.workbenchDao.selectWorkOrderOverdueCount(currentOrgId);



        Long workOrderOverdueCount = bpmTaskManager.getTodoCountByUserIdOverdue(userId);

        //已逾期养护工单
//        Long workOrderOverdueCountTrue =  this.workbenchDao.workOrderOverdueCountTrue(currentOrgId);

        Long workOrderOverdueCountTrue = bpmTaskManager.getTodoCountByUserIdTimeOut(userId);
        map.put("diseaseOverdueCount",diseaseOverdueCount);
        map.put("diseaseOverdueCountTrue",diseaseOverdueCountTrue);
        map.put("workOrderOverdueCount",workOrderOverdueCount);
        map.put("workOrderOverdueCountTrue",workOrderOverdueCountTrue);
        return map;
    }

    @Override
    public Map<String, Object> getRegularCheck() {
        String currentOrgId = baseContext.getCurrentOrgId();
        List<String> ids = this.getOrgIds(currentOrgId);

        Map<String, Object> map = new HashMap<>();

        //桥梁
        //一级 一年
        Long brideOneCount = this.workbenchDao.brideOneCount(ids);
        //二三级别  3年
        Long brideThreeCount = this.workbenchDao.brideThreeCount(ids);
        //涵洞
        Long culvertCount = this.workbenchDao.culvertCount(ids);
        //隧道
        Long tunnelCount = this.workbenchDao.tunnelCount(ids);
        //边坡
        Long sideSlopeCount = this.workbenchDao.sideSlopeCount(ids);
        map.put("brideRegularCount",brideOneCount+brideThreeCount);
        map.put("culvertRegularCount",culvertCount);
        map.put("tunnelRegularCount",tunnelCount);
        map.put("sideSlopeRegularCount",sideSlopeCount);
        return map;
    }

    private List<String> getOrgIds (String currentOrgId){
        List<Org> orgList = orgManager.getByParentId(currentOrgId);
        List<String> collect = orgList.stream().map(Org::getId).collect(Collectors.toList());
        collect.add(currentOrgId);
        return collect;
    }


    @Override
    public Map<String, Object> getOftenCheck() {
        String currentOrgId = baseContext.getCurrentOrgId();
        List<String> ids = this.getOrgIds(currentOrgId);

        Map<String, Object> map = new HashMap<>();


        //桥梁
        //一级
        List<String> brideOneOftenCountList = this.workbenchDao.brideOneOftenCount(ids);
        if(null == brideOneOftenCountList){
            brideOneOftenCountList=new ArrayList<>();
        }


//        //二
        List<String> brideTwoOftenCountList = this.workbenchDao.brideTwoOftenCount(ids);
        if(null == brideTwoOftenCountList){
            brideTwoOftenCountList=new ArrayList<>();
        }


//        // 三级别
//        Long brideThreeOftenCount = this.workbenchDao.brideThreeOftenCount(ids);
        //涵洞
        List<String> culvertOftenCountList = this.workbenchDao.culvertOftenCount(ids);
        if(null == culvertOftenCountList){
            culvertOftenCountList=new ArrayList<>();
        }


        //隧道
        List<String> tunnelOneOftenCountList = this.workbenchDao.tunnelOneOftenCount(ids);
        if(null == tunnelOneOftenCountList){
            tunnelOneOftenCountList=new ArrayList<>();
        }


        List<String> tunnelTwoOftenCountList = this.workbenchDao.tunnelTwoOftenCount(ids);
        if(null == tunnelTwoOftenCountList){
            tunnelTwoOftenCountList=new ArrayList<>();
        }
        List<String> tunnelThreeOftenCountList = this.workbenchDao.tunnelThreeOftenCount(ids);
        if(null == tunnelThreeOftenCountList){
            tunnelThreeOftenCountList=new ArrayList<>();
        }
        //边坡
        List<String> sideSlopeOftenCountList = this.workbenchDao.sideSlopeOftenCount(ids);

        if(null == sideSlopeOftenCountList){
            sideSlopeOftenCountList=new ArrayList<>();
        }


        map.put("brideOftenCount",brideOneOftenCountList.size()+brideTwoOftenCountList.size());
        map.put("culvertOftenCount",culvertOftenCountList.size());
        map.put("tunnelOftenCount",tunnelOneOftenCountList.size()+ tunnelTwoOftenCountList.size()+ tunnelThreeOftenCountList.size());
        map.put("sideSlopeOftenCount",sideSlopeOftenCountList.size());
        return map;
    }
}
