package com.artfess.yhxt.statistics.dao;

import com.artfess.yhxt.statistics.vo.*;
import com.baomidou.mybatisplus.annotation.SqlParser;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * @author zhx
 * @create 2022/1/6
 */
public interface StatisticalStatementDao {
    /**
     * 道路病害统计 -检测类别统计
     * 日巡检 diseaseDay 夜巡检 diseaseNight 桥梁经常检查 diseaseBridgeOften 隧道经常检查  diseaseTunnelOften
     * 涵洞经常检查 diseaseCulvertOften 边坡经常检查 diseaseSideSlopeOften 桥梁定期检查 diseaseBridgeRegular
     * 隧道定期检查 diseaseTunnelRegular 涵洞定期检查 diseaseCulvertRegular 边坡定期检查 diseaseSideSlopeRegular
     * @return
     */
    DiseaseCategoryVo countDiseaseCategory(@Param("map") Map<String, Object> map);

    /**
     * 处理情况 处理情况，0：未处理，1：处理中，2：已处理，3：观察记录
     * 未处理 handlingSituationNo 处理中 handlingSituationRun
     * 已处理 handlingSituationYes 观察记录 handlingSituationObserve
     * @return
     */
    DiseaseHandlingSituationVo countDiseaseHandlingSituation(@Param("map") Map<String, Object> map);
    //病害类别
    Integer countDiseaseSubject(@Param("subjectCode") String subjectCode,@Param("map") Map<String, Object> map );

    /**病害部位
     * diseasePositionRamp 匝道
     * diseasePositionTollGate 收费站
     * diseasePositionCoverage 服务区
     * diseasePositionManageStation 管理站房
     * diseasePositionOther 其他
     * @return
     */
    DiseasePositionVo countPosition(@Param("map") Map<String, Object> map);

    /**
     * 根据细目查询养护金额
     * @return
     */
    @SqlParser(filter = true)
    List<MaintenanceEveryMoneyVo> countMaintenanceEveryMoney(@Param("map") Map<String, Object> map);

    /**
     * 各个年份金额统计
     * @return
     */
    @SqlParser(filter = true)
    List<MaintenanceYearMoney> countMaintenanceYearMoney(@Param("map") Map<String, Object> map);
    /**
     * 各个路段金额统计
     * @return
     */
    @SqlParser(filter = true)
    List<MaintenanceRoadMoneyVo> countMaintenanceRoadMoney(@Param("map") Map<String, Object> map);

    List<InspectForRoadSegment> countSiteDaily(@Param("map") Map<String, Object> map);

    List<InspectForRoadSegment> countSiteNight(@Param("map") Map<String, Object> map);

    /**
     * 桥梁类型
     * @param map
     * @return
     */
    List<Map<String, Object>> countBridgeType(@Param("map") Map<String, Object> map);
    /**
     *桥梁类别
     * @param map
     * @return
     */
    List<Map<String, Object>> countBridgeShapeType(@Param("map") Map<String, Object> map);
    /**
     *上部结构
     * @param map
     * @return
     */
    List<Map<String, Object>> countBridgeCategory(@Param("map") Map<String, Object> map);

    /**
     * 只传年份时查询应巡检
     * @param map
     * @param ids  桥梁ID
     * @return
     */
    Integer countBridgeCheckYear(@Param("map") Map<String, Object> map,@Param("ids") List<String> ids);

    /**
     * 按照月份进行查询
     * @param map
     */
    Integer countBridgeCheckMouth(@Param("map") Map<String, Object> map,@Param("ids") List<String> ids);

    /**
     * 只传年份时查询应巡检
     * @param map
     * @param ids
     * @return
     */
    Integer countTunnelCheckYear(@Param("map") Map<String, Object> map,@Param("ids") List<String> ids);

    /**
     * 按照月份进行查询
     * @param map
     * @param ids
     * @return
     */
    Integer countTunnelCheckMouth(@Param("map") Map<String, Object> map, @Param("ids") List<String> ids);

    /**
     *
     * @param map
     * @param ids
     * @return
     */
    Integer countSideSlopeCheckYear(@Param("map")Map<String, Object> map, @Param("ids") List<String> ids);

    /**
     *
     * @param map
     * @param ids
     * @return
     */
    Integer countSideSlopeCheckMouth(@Param("map")Map<String, Object> map, @Param("ids") List<String> ids);

    /**
     *
     * @param map
     * @param ids
     * @return
     */
    Integer countCulvertCheckYear(@Param("map")Map<String, Object> map, @Param("ids") List<String> ids);

    /**
     *
     * @param map
     * @param ids
     * @return
     */
    Integer countCulvertCheckMouth(@Param("map")Map<String, Object> map, @Param("ids") List<String> ids);

    /**
     * 查询mqi对应的数据
     * @param map
     * @return
     */
    List<MqiDataVo> listMqi(Map<String, Object> map);

    Float countMqiAvg(@Param("ids") List<String> ids);

    Float countPqiAvg(@Param("ids") List<String> ids);

    Float countPciAvg(@Param("ids") List<String> ids);

    Float countRqiAvg(@Param("ids") List<String> ids);

    Float countRdiAvg(@Param("ids") List<String> ids);

    Float countPbiAvg(@Param("ids") List<String> ids);

    Float countSriAvg(@Param("ids") List<String> ids);

    Float countSciAvg(@Param("ids") List<String> ids);

    Float countBciAvg(@Param("ids") List<String> ids);

    Float countTciAvg(@Param("ids") List<String> ids);

    Float countPwiAvg(@Param("ids") List<String> ids);

    Float countPssiAvg(@Param("ids") List<String> ids);

    List<CountStructureVo> countStructure(@Param("map") Map<String, Object> map);

    List<CountMaintenanceNew> countMaintenanceNew(@Param("map") Map<String, Object> map);
}
