package com.artfess.yhxt.specialproject.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 项目周报月报表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-12
 */
@ApiModel(value="BizProjectWeeklyMonthlyReport对象", description="项目周报月报表")
@TableName("biz_project_weekly_monthly_report")
@Data
public class BizProjectWeeklyMonthlyReport extends BizModel<BizProjectWeeklyMonthlyReport> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "路段id")
    @TableField("ROAD_SEGMENT_ID_")
    private String roadSegmentId;

    @ApiModelProperty(value = "路段NAME")
    @TableField("ROAD_SEGMENT_NAME_")
    private String roadSegmentName;

    @ApiModelProperty(value = "项目表id,关联工程项目表")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "项目名称")
    @TableField("PROJECT_NAME_")
    private String projectName;

    @ApiModelProperty(value = "填报类型，使用数据字典，1：周报，2：月报")
    @TableField("PORT_TYPE_")
    private Integer portType;

    @ApiModelProperty(value = "填报日期，添加数据时后台自动填写")
    @TableField("PORT_DATE_")
    private LocalDate portDate;

    @ApiModelProperty(value = "填报方，使用数据字典，1：业主方，2：监理方，3：设计方，4：施工方")
    @TableField("PORT_UNIT_")
    private Integer portUnit;

    @ApiModelProperty(value = "形象进度，百分比数值")
    @TableField("IMAGE_PROGRESS_")
    private String imageProgress;

    @ApiModelProperty(value = "工程概况")
    @TableField("PROJECT_OVERVIEW")
    private String projectOverview;

    @ApiModelProperty(value = "本周(月)工作")
    @TableField("WEEKLY_MOUTHLY_WORK_")
    private String weeklyMouthlyWork;

    @ApiModelProperty(value = "工程变更情况")
    @TableField("ENGINEERING_CHANGE_")
    private String engineeringChange;

    @ApiModelProperty(value = "下步计划")
    @TableField("NEXT_STEP_PLAN_")
    private String nextStepPlan;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "进度描述")
    @TableField("PROGRESS_DESCRIPTION_")
    private String progressDescription;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Integer getPortType() {
        return portType;
    }

    public void setPortType(Integer portType) {
        this.portType = portType;
    }
    public LocalDate getPortDate() {
        return portDate;
    }

    public void setPortDate(LocalDate portDate) {
        this.portDate = portDate;
    }
    public Integer getPortUnit() {
        return portUnit;
    }

    public void setPortUnit(Integer portUnit) {
        this.portUnit = portUnit;
    }
    public String getImageProgress() {
        return imageProgress;
    }

    public void setImageProgress(String imageProgress) {
        this.imageProgress = imageProgress;
    }
    public String getProjectOverview() {
        return projectOverview;
    }

    public void setProjectOverview(String projectOverview) {
        this.projectOverview = projectOverview;
    }
    public String getWeeklyMouthlyWork() {
        return weeklyMouthlyWork;
    }

    public void setWeeklyMouthlyWork(String weeklyMouthlyWork) {
        this.weeklyMouthlyWork = weeklyMouthlyWork;
    }
    public String getEngineeringChange() {
        return engineeringChange;
    }

    public void setEngineeringChange(String engineeringChange) {
        this.engineeringChange = engineeringChange;
    }
    public String getNextStepPlan() {
        return nextStepPlan;
    }

    public void setNextStepPlan(String nextStepPlan) {
        this.nextStepPlan = nextStepPlan;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    public String getProgressDescription() {
        return progressDescription;
    }

    public void setProgressDescription(String progressDescription) {
        this.progressDescription = progressDescription;
    }
    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizProjectWeeklyMonthlyReport{" +
            "id=" + id +
            ", projectId=" + projectId +
            ", projectName=" + projectName +
            ", portType=" + portType +
            ", portDate=" + portDate +
            ", portUnit=" + portUnit +
            ", imageProgress=" + imageProgress +
            ", projectOverview=" + projectOverview +
            ", weeklyMouthlyWork=" + weeklyMouthlyWork +
            ", engineeringChange=" + engineeringChange +
            ", nextStepPlan=" + nextStepPlan +
            ", remarks=" + remarks +
            ", progressDescription=" + progressDescription +
            ", companyId=" + companyId +
            ", companyName=" + companyName +
        "}";
    }
}
