package com.artfess.yhxt.specialproject.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 工程附件表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-12
 */
@ApiModel(value="BizEngineeringAccessories对象", description="工程附件表")
@TableName("biz_engineering_accessories")
public class BizEngineeringAccessories extends BizModel<BizEngineeringAccessories> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "竣工审批id")
    @TableField("ATTACHMENT_ID_")
    private String attachmentId;

    @ApiModelProperty(value = "对应资源ID")
    @TableField("SOURCE_ID_")
    private String sourceId;

    @ApiModelProperty(value = "项目ID")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "子项目ID")
    @TableField("SUB_PROJECT_ID_")
    private String subProjectId;

    @ApiModelProperty(value = "资料类别，1：招投标附件，2：合同附件，3：开工信息附件，4：安全环保，" +
            "5：巡检记录附件，6：项目日志附件，7：项目周报月报附件，8：质量管理附件，10：民工管理附件" +
            "，11：交工信息附件，12：计量支付附件，13：验收信息附近")
    @TableField("TYPE_")
    private Integer type;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "附件名称")
    @TableField("ATTACHMENT_NAME_")
    private String attachmentName;

    @ApiModelProperty(value = "附件扩展名")
    @TableField("ATTACHMENT_SUFFIX_")
    private String attachmentSuffix;

    @ApiModelProperty(value = "附件路径")
    @TableField("ATTACHMENT_PATH_")
    private String attachmentPath;

    @ApiModelProperty(value = "附件类别")
    @TableField("ATTACHMENT_TYPE_")
    private String attachmentType;

    @ApiModelProperty(value = "附件拥有者")
    @TableField("OWNER_ID_")
    private String ownerId;

    @ApiModelProperty(value = "1-有效（默认值）、0-无效")
    @TableField("VALID_FLAG_")
    private Integer validFlag;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getAttachmentId() {
        return attachmentId;
    }

    public void setAttachmentId(String attachmentId) {
        this.attachmentId = attachmentId;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getSubProjectId() {
        return subProjectId;
    }

    public void setSubProjectId(String subProjectId) {
        this.subProjectId = subProjectId;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    public String getAttachmentName() {
        return attachmentName;
    }

    public void setAttachmentName(String attachmentName) {
        this.attachmentName = attachmentName;
    }
    public String getAttachmentSuffix() {
        return attachmentSuffix;
    }

    public void setAttachmentSuffix(String attachmentSuffix) {
        this.attachmentSuffix = attachmentSuffix;
    }
    public String getAttachmentPath() {
        return attachmentPath;
    }

    public void setAttachmentPath(String attachmentPath) {
        this.attachmentPath = attachmentPath;
    }
    public String getAttachmentType() {
        return attachmentType;
    }

    public void setAttachmentType(String attachmentType) {
        this.attachmentType = attachmentType;
    }
    public String getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }
    public Integer getValidFlag() {
        return validFlag;
    }

    public void setValidFlag(Integer validFlag) {
        this.validFlag = validFlag;
    }
    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizEngineeringAccessories{" +
            "id=" + id +
            ", attachmentId=" + attachmentId +
            ", remarks=" + remarks +
            ", attachmentName=" + attachmentName +
            ", attachmentSuffix=" + attachmentSuffix +
            ", attachmentPath=" + attachmentPath +
            ", attachmentType=" + attachmentType +
            ", ownerId=" + ownerId +
            ", validFlag=" + validFlag +
            ", companyId=" + companyId +
            ", companyName=" + companyName +
        "}";
    }
}
