package com.artfess.yhxt.disease.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class DiseaseReportVO {
    @ApiModelProperty("路段名称")
    private String roadName;
    @ApiModelProperty("病害总数")
    private int diseaseCount;
    @ApiModelProperty("日常巡检总数")
    private int dailyCount;
    @ApiModelProperty("经常检查总数")
    private int oftenCount;
    @ApiModelProperty("定期检查总数")
    private int regularCount;
    @ApiModelProperty("临时发现总数")
    private int temporaryCount;
    @ApiModelProperty("路基")
    private int bedCount;
    @ApiModelProperty("路面")
    private int roadCount;
    @ApiModelProperty("桥梁")
    private int bridgeCount;
    @ApiModelProperty("隧道")
    private int tunnelCount;
    @ApiModelProperty("涵洞")
    private int culvertCount;
    @ApiModelProperty("边坡")
    private int highWallCount;
    @ApiModelProperty("绿化")
    private int greenCount;
    @ApiModelProperty("未处理")
    private int untreatedCount;
    @ApiModelProperty("已处理")
    private int finishCount;
    @ApiModelProperty("处置率")
    private BigDecimal finishRate;
    @ApiModelProperty("派单数量")
    private int orderCount;
    @ApiModelProperty("平均处理时间")
    private String handleTime;
}
