package com.artfess.yhxt.contract.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author zhx
 * @create 2022/6/9
 */
@Data
@ApiModel(value = "WorkOrderContract vo对象", description = "工程(中期计量、完工结算)清单表")
public class WorkOrderContractVo {

    @ApiModelProperty(value = "主键ID")
    private String idContract;

    @ApiModelProperty(value = "科目编码")
    private String codeContract;

    @ApiModelProperty(value = "科目名称")
    private String subjectNameContract;

    @ApiModelProperty(value = "细科目编码")
    private String fineSubjectCodeContract;

    @ApiModelProperty(value = "细科目名称")
    private String fineSubjectNameContract;

    @ApiModelProperty(value = "子科目编码")
    private String sonSubjectCodeContract;

    @ApiModelProperty(value = "子科目名称")
    private String sonSubjectNameContract;

    @ApiModelProperty(value = "单位")
    private String specContract;

    @ApiModelProperty(value = "单价（元）")
    private Double priceContract=0.0;

    @ApiModelProperty(value = "数量")
    private Double amountContract=0.0;

    @ApiModelProperty(value = "金额（元）")

    private Double montyContract;

    @ApiModelProperty(value = "对应合同ID")
    private String contractId;

    @ApiModelProperty(value = "主键ID")
    private String idBill;
    @ApiModelProperty(value = "明细表科目编码")
    private String numberBill;

    @ApiModelProperty(value = "明细表科目名称")
    private String subjectNameBill;

    @ApiModelProperty(value = "明细表细科目编码")
    private String fineSubjectCodeBill;

    @ApiModelProperty(value = "明细表细科目名称")
    private String fineSubjectNameBill;

    @ApiModelProperty(value = "子科目编码")
    private String sonSubjectCodeBill;

    @ApiModelProperty(value = "子科目名称")
    private String sonSubjectNameBill;

    @ApiModelProperty(value = "审核单价（元）")
    private Float auditPriceBill=0f;

    @ApiModelProperty(value = "审核数量")
    private Float auditAmountBill=0f;

    @ApiModelProperty(value = "审核金额（元）")
    private Float auditMoneyBill=0f;
}
