package com.artfess.yhxt.contract.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 合同表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 超级管理员
 * @since 2021-08-06
 */
@ApiModel(value="Contract对象", description="合同表")
@TableName("BIZ_CONTRACT")
@Data
public class Contract extends BizModel<Contract> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "路段id(关联路段表ID)")
    @TableField("ROAD_SEGMENT_ID_")
    private String roadSegmentId;

    @ApiModelProperty(value = "路段名称")
    @TableField("ROAD_SEGMENT_NAME_")
    private String roadSegmentName;

    @ApiModelProperty(value = "管养单位_ID")
    @TableField("OFFICE_ID_")
    private String officeId;

    @ApiModelProperty(value = "管养单位名称")
    @TableField("OFFICE_NAME_")
    private String officeName;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "发起人")
    @TableField("INITIATOR_")
    private String initiator;

    @ApiModelProperty(value = "合同名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "合同类型")
    @TableField("TYPE_")
    private String type;

    @ApiModelProperty(value = "类型值")
    @TableField("TYPE_VALUE_")
    private String typeValue;

    @ApiModelProperty(value = "第一方")
    @TableField("FIRST_PARTY_")
    private String firstParty;

    @ApiModelProperty(value = "第二方")
    @TableField("SECOND_PARTY_")
    private String secondParty;

    @ApiModelProperty(value = "第三方")
    @TableField("THIRD_PARTY_")
    private String thirdParty;

    @ApiModelProperty(value = "合同编号")
    @TableField("CONTRACT_NUMBER_")
    private String contractNumber;

    @ApiModelProperty(value = "唯一编号")
    @TableField("UNIQUE_NUMBER_")
    private String uniqueNumber;

    @ApiModelProperty(value = "分类编号")
    @TableField("CLASSIFICATION_NUMBER_")
    private String classificationNumber;

    @ApiModelProperty(value = "合同金额")
    @TableField("CONTRACT_AMOUNT_")
    private Double contractAmount;

    @ApiModelProperty(value = "保证金")
    @TableField("RETENTION_MONEY_")
    private Double retentionMoney;

    @ApiModelProperty(value = "合同日期")
    @TableField("CONTRACT_DATE_")
    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    private Date contractDate;

    @ApiModelProperty(value = "合同到期时间")
    @TableField("CONTRACT_DATE_LIMIT_")
    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    private Date contractDateLimit;

    @ApiModelProperty(value = "条约内容")
    @TableField("TREATY_CONTENTS_")
    private String treatyContents;

    @ApiModelProperty(value = "确认模式")
    @TableField("CONFIRMATION_MODE_")
    private String confirmationMode;

    @ApiModelProperty(value = "附件地址")
    @TableField("URL_")
    private String url;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "是否正式合同 0:临时合同  1: 正式合同")
    @TableField("IS_TEMPORARY_")
    private Integer isTemporary;


}
