package com.artfess.yhxt.check.detail.model;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 涵洞经常检查明细表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-05
 */
@ApiModel(value="BizCulvertOftenCheckDetail对象", description="涵洞经常检查明细表")
@TableName("BIZ_CULVERT_OFTEN_CHECK_DETAIL")
public class CulvertOftenCheckDetail extends BaseModel<CulvertOftenCheckDetail> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "涵洞经常检查表ID")
    @TableField("CULVERT_OFTEN_CHECK_ID_")
    private String culvertOftenCheckId;

    @Excel(name = "检查项目", orderNum = "0")
    @ApiModelProperty(value = "检查项目")
    @TableField("CHECK_PROJECT_")
    private String checkProject;

    @Excel(name = "判断结论", orderNum = "1")
    @ApiModelProperty(value = "判断结论")
    @TableField("RESULT_")
    private String result;

    @Excel(name = "状态描述", orderNum = "2")
    @ApiModelProperty(value = "状态描述")
    @TableField("STATUS_DESC_")
    private String statusDesc;

    @Excel(name = "处理措施", orderNum = "3")
    @ApiModelProperty(value = "处理措施")
    @TableField("PROCESS_")
    private String process;

    @Excel(name = "备注", orderNum = "4")
    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getCulvertOftenCheckId() {
        return culvertOftenCheckId;
    }

    public void setCulvertOftenCheckId(String culvertOftenCheckId) {
        this.culvertOftenCheckId = culvertOftenCheckId;
    }
    public String getCheckProject() {
        return checkProject;
    }

    public void setCheckProject(String checkProject) {
        this.checkProject = checkProject;
    }
    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }
    public String getStatusDesc() {
        return statusDesc;
    }

    public void setStatusDesc(String statusDesc) {
        this.statusDesc = statusDesc;
    }
    public String getProcess() {
        return process;
    }

    public void setProcess(String process) {
        this.process = process;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Override
    protected Serializable pkVal() {
        return null;
    }

    @Override
    public String toString() {
        return "BizCulvertOftenCheckDetail{" +
            "id=" + id +
            ", culvertOftenCheckId=" + culvertOftenCheckId +
            ", checkProject=" + checkProject +
            ", result=" + result +
            ", statusDesc=" + statusDesc +
            ", process=" + process +
            ", remarks=" + remarks +
        "}";
    }
}
