package com.artfess.yhxt.basedata.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 科目明细表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-07-30
 */
@ApiModel(value="BizCourseDetails对象", description="科目明细表")
@TableName("biz_course_details")
public class BizCourseDetails extends BizModel<BizCourseDetails> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "科目ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "父科目ID")
    @TableField("PCODE_")
    private String pcode;

    @ApiModelProperty(value = "父科目名称")
    @TableField("PNAME_")
    private String pname;

    @ApiModelProperty(value = "科目编码")
    @TableField("SUBJECT_CODE_")
    private String subjectCode;

    @ApiModelProperty(value = "科目名称")
    @TableField("SUBJECT_NAME_")
    private String subjectName;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "所属公司多个ID")
    @TableField("COMPANY_IDS_")
    private String companyIds;

    @ApiModelProperty(value = "所属公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "是否有子节点")
    @TableField("HAS_CHILDREN")
    private String hasChildren;

    @ApiModelProperty(value = "排序号")
    @TableField("SN_")
    private int sn;
    @ApiModelProperty(value = "路段id")
    @TableField("ROAD_SEGMENT_ID_")
    private String roadSegmentId;

    @ApiModelProperty(value = "路段NAME")
    @TableField("ROAD_SEGMENT_NAME_")
    private String roadSegmentName;

    public String getRoadSegmentId() {
        return roadSegmentId;
    }

    public void setRoadSegmentId(String roadSegmentId) {
        this.roadSegmentId = roadSegmentId;
    }

    public String getRoadSegmentName() {
        return roadSegmentName;
    }

    public void setRoadSegmentName(String roadSegmentName) {
        this.roadSegmentName = roadSegmentName;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPcode() {
        return pcode;
    }

    public void setPcode(String pcode) {
        this.pcode = pcode;
    }

    public String getPname() {
        return pname;
    }

    public void setPname(String pname) {
        this.pname = pname;
    }

    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getHasChildren() {
        return hasChildren;
    }

    public void setHasChildren(String hasChildren) {
        this.hasChildren = hasChildren;
    }

    public int getSn() {
        return sn;
    }

    public void setSn(int sn) {
        this.sn = sn;
    }

    public String getCompanyIds() {
        return companyIds;
    }

    public void setCompanyIds(String companyIds) {
        this.companyIds = companyIds;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizCourseDetails{" +
                "id='" + id + '\'' +
                ", pcode='" + pcode + '\'' +
                ", pname='" + pname + '\'' +
                ", subjectCode='" + subjectCode + '\'' +
                ", subjectName='" + subjectName + '\'' +
                ", companyId='" + companyId + '\'' +
                ", companyIds='" + companyIds + '\'' +
                ", companyName='" + companyName + '\'' +
                ", hasChildren='" + hasChildren + '\'' +
                ", sn=" + sn +
                ", roadSegmentId='" + roadSegmentId + '\'' +
                ", roadSegmentName='" + roadSegmentName + '\'' +
                '}';
    }
}
