package com.artfess.yhxt.basedata.manager.impl;

import com.artfess.file.util.MinioUtil;
import com.artfess.yhxt.basedata.manager.*;
import com.artfess.yhxt.basedata.model.*;
import com.artfess.yhxt.basedata.dao.BizEngineeringDrawingDao;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.basedata.vo.BizEngineeringDrawingVo;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;

/**
 * 工程图纸表 服务实现类
 *
 * @author wangping
 * @company 阿特菲斯信息技术有限公司
 * @since 2021-08-02
 */
@Service
public class BizEngineeringDrawingManagerImpl extends BaseManagerImpl<BizEngineeringDrawingDao, BizEngineeringDrawing> implements BizEngineeringDrawingManager {

    @Resource
    BridgeInformationManager bridgeInformationManager;
    @Resource
    TunnelInformationManager tunnelInformationManager;
    @Resource
    SideSlopeInformationManager sideSlopeInformationManager;
    @Resource
    BizCulvertInformationManager culvertInformationManager;
    @Resource
    private AccessoryManager accessoryManager;

    @Override
    public PageList<BizEngineeringDrawing> queryBizEngineeringDrawing(QueryFilter<BizEngineeringDrawing> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();

        IPage<BizEngineeringDrawing> result = baseMapper.getBizEngineeringDrawing(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<BizEngineeringDrawing>(result);
    }

    @Override
    public void updateBizEngineeringDrawing(String id) {
        UpdateWrapper<BizEngineeringDrawing> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq(StringUtils.isNotBlank(id), "id_", id);
        updateWrapper.set("is_dele_", "1");
        baseMapper.update(null, updateWrapper);
    }

    @Override
    public String minioDrawingUpload(MultipartFile file) {
        String miniourl = MinioUtil.getMinioUrl();
        if (file.isEmpty() || file.getSize() == 0) {
            throw new RuntimeException("文件为空");
        }
        String fileName = file.getOriginalFilename();
        String name = DigestUtils.md5Hex(UUID.randomUUID().toString()) + fileName.substring(fileName.lastIndexOf("."));
        String url = null;
        try {
            url = MinioUtil.uploadRelative(file, "/drawing", name, "yhxt");
        } catch (Exception e) {
            e.printStackTrace();
        }
        return miniourl + url;
    }

    @Override
    public void updateByBridgeCoordinate(String id, String x, String y) {
        UpdateWrapper<BridgeInformation> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("ID_", id);
        updateWrapper.set("X_", x);
        updateWrapper.set("Y_", y);
        this.bridgeInformationManager.update(null, updateWrapper);
    }

    @Override
    public void updateByTunnelCoordinate(String id, String x, String y) {
        UpdateWrapper<TunnelInformation> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("ID_", id);
        updateWrapper.set("X_", x);
        updateWrapper.set("Y_", y);
        this.tunnelInformationManager.update(null, updateWrapper);
    }

    @Override
    public void updateBySideSlopeCoordinate(String id, String x, String y) {
        UpdateWrapper<SideSlopeInformation> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("ID_", id);
        updateWrapper.set("X_", x);
        updateWrapper.set("Y_", y);
        this.sideSlopeInformationManager.update(null, updateWrapper);
    }

    @Override
    public void updateByCulvertCoordinate(String id, String x, String y) {
        UpdateWrapper<BizCulvertInformation> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("ID_", id);
        updateWrapper.set("X_", x);
        updateWrapper.set("Y_", y);
        this.culvertInformationManager.update(null, updateWrapper);
    }

    @Override
    public void saveVo(BizEngineeringDrawingVo bizEngineeringDrawingVo) {
        //工程图纸
        BizEngineeringDrawing bizEngineeringDrawing = bizEngineeringDrawingVo.getBizEngineeringDrawing();
        //保存工程图纸信息
        this.create(bizEngineeringDrawing);

        //保存附件信息
        List<Accessory> accessoryList = bizEngineeringDrawingVo.getAccessories();
        //资源ID
        String id = bizEngineeringDrawing.getId();
        if (accessoryList.size() > 0) {
            //删除原来的附件信息
           // this.accessoryManager.delAccessoryBySourceId(id);
            //设置附件资源ID
            accessoryList.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveBatch(accessoryList);
        }

    }

    @Override
    public void updateVo(BizEngineeringDrawingVo bizEngineeringDrawingVo) {
        //工程图纸
        BizEngineeringDrawing bizEngineeringDrawing = bizEngineeringDrawingVo.getBizEngineeringDrawing();
        //附件信息
        List<Accessory> accessoryList = bizEngineeringDrawingVo.getAccessories();
        //修改施工人员信息
        this.update(bizEngineeringDrawing);
        //资源ID
        String id = bizEngineeringDrawing.getId();
        if (accessoryList.size()>0) {
            //删除原来的附件信息
            this.accessoryManager.delAccessoryBySourceId(id);
            //获取附件信息
            accessoryList.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveOrUpdateBatch(accessoryList);
        }
    }

    @Override
    public BizEngineeringDrawingVo getVo(String id) {
        BizEngineeringDrawingVo bizEngineeringDrawingVo = new BizEngineeringDrawingVo();
        //获取施工人员信息
        BizEngineeringDrawing bizEngineeringDrawing = this.baseMapper.selectById(id);
        //获取附件信息
        List<Accessory> accessoryList = this.accessoryManager.getAccessoryBySourceId(id);
        bizEngineeringDrawingVo.setBizEngineeringDrawing(bizEngineeringDrawing);
        bizEngineeringDrawingVo.setAccessories(accessoryList);
        return bizEngineeringDrawingVo;
    }

}
