package com.artfess.yhxt.basedata.manager.impl;

import com.artfess.yhxt.basedata.model.BizCourseDetails;
import com.artfess.yhxt.basedata.dao.BizCourseDetailsDao;
import com.artfess.yhxt.basedata.manager.BizCourseDetailsManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 科目明细表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 王平
 * @since 2021-07-30
 */
@Service
public class BizCourseDetailsManagerImpl extends BaseManagerImpl<BizCourseDetailsDao, BizCourseDetails> implements BizCourseDetailsManager {



    @Override
    public PageList<BizCourseDetails> queryBizCourseDetails(QueryFilter<BizCourseDetails> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();

        IPage<BizCourseDetails> result = baseMapper.getBizCourseDetails(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<BizCourseDetails>(result);
    }

    @Override
    public void updateBizCourseDetails(String id) {
        UpdateWrapper<BizCourseDetails> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq(StringUtils.isNotBlank(id), "id_", id);
        updateWrapper.set("is_dele_", "1");
        baseMapper.update(null, updateWrapper);
    }

    @Override
    public List<BizCourseDetails> getByParentId(String pCode) {
        List<BizCourseDetails> bcdList = new ArrayList<BizCourseDetails>();
        List<BizCourseDetails> allList = this.getList();
        return getChild(allList, pCode, bcdList);
    }

    private List<BizCourseDetails> getList() {
        QueryWrapper<BizCourseDetails> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("IS_DELE_","0");
        return baseMapper.selectList(queryWrapper);
    }

    /**
     * 获取某个父节点下面的所有子节点
     *
     * @param
     * @param
     * @return
     */
    public static List<BizCourseDetails> getChild(List<BizCourseDetails> bizCourseDetailsList, String pCode, List<BizCourseDetails> bcdList) {
        for (BizCourseDetails bizCourseDetails : bizCourseDetailsList) {
            // 遍历出父id等于参数的id，add进子节点集合
            if (pCode.equals(bizCourseDetails.getPcode())) {
                // 递归遍历下一级
                getChild(bizCourseDetailsList, bizCourseDetails.getId(), bcdList);
                bcdList.add(bizCourseDetails);
            }
        }
        return bcdList;
    }


    @Override
    public void updateByPcode(String pcode) {
        QueryWrapper<BizCourseDetails> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("PCODE_",pcode);
        queryWrapper.eq("IS_DELE_","0");
        Integer count = this.baseMapper.selectCount(queryWrapper);
        if (count==0){
            UpdateWrapper<BizCourseDetails> updateWrapper = new UpdateWrapper<>();
            updateWrapper.eq("SUBJECT_CODE_",pcode);
            updateWrapper.set("HAS_CHILDREN","false");
            this.baseMapper.update(null,updateWrapper);
        }else {
            UpdateWrapper<BizCourseDetails> updateWrapper = new UpdateWrapper<>();
            updateWrapper.eq("SUBJECT_CODE_",pcode);
            updateWrapper.set("HAS_CHILDREN","true");
            this.baseMapper.update(null,updateWrapper);
        }


    }

    @Override
    public void checkCode(BizCourseDetails bizCourseDetails) {


        QueryWrapper<BizCourseDetails> queryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotBlank(bizCourseDetails.getId())){
            queryWrapper.notIn("ID_",bizCourseDetails.getId());
        }
        queryWrapper.eq(StringUtils.isNotBlank(bizCourseDetails.getPcode()),"PCODE_",bizCourseDetails.getPcode());
        queryWrapper.eq(StringUtils.isNotBlank(bizCourseDetails.getSubjectCode()),"SUBJECT_CODE_",bizCourseDetails.getSubjectCode());
        queryWrapper.eq("IS_DELE_","0");
        List<BizCourseDetails> details = this.baseMapper.selectList(queryWrapper);
        if (details.size()>0){
            throw new RuntimeException("编码重复请重新添加");
        }
    }

    @Override
    public void updateHasChildren(String ids) {
         if (StringUtils.isNotBlank(ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
             QueryWrapper<BizCourseDetails> queryWrapper = new QueryWrapper<>();
             queryWrapper.in("ID_",idsList);
             queryWrapper.select("DISTINCT PCODE_");
             List<BizCourseDetails> details = this.baseMapper.selectList(queryWrapper);
             for (BizCourseDetails detail : details) {
                this.updateByPcode(detail.getPcode());
             }

         }
    }

    @Override
    public void checkHasChildren(List<String> idsList) {
        for (String id : idsList) {
            BizCourseDetails details = this.getById(id);
            if ( details.getHasChildren()!=null && details.getHasChildren().equals("true")){
                throw new RuntimeException("请先删除子节点");
            }
        }
    }

    @Override
    public String getByName(String code) {
        QueryWrapper<BizCourseDetails> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("SUBJECT_CODE_",code);
        queryWrapper.eq("IS_DELE_","0");
        BizCourseDetails bizCourseDetails = baseMapper.selectOne(queryWrapper);
        if (bizCourseDetails!=null) {
            return bizCourseDetails.getSubjectName();
        }else {
            return "";
        }
    }

    @Override
    public List<BizCourseDetails> getByParentIdRoad(String pCode, String roadSegmentId) {
        QueryWrapper<BizCourseDetails> bizCourseDetailsQueryWrapper = new QueryWrapper<>();
        bizCourseDetailsQueryWrapper.eq(StringUtils.isNotEmpty(pCode),"PCODE_",pCode);
        bizCourseDetailsQueryWrapper.eq(StringUtils.isEmpty(pCode),"PCODE_","root");
        bizCourseDetailsQueryWrapper.in(StringUtils.isNotEmpty(roadSegmentId),"ROAD_SEGMENT_ID_",Arrays.asList(roadSegmentId.split(",")));
        List<BizCourseDetails> list = this.list(bizCourseDetailsQueryWrapper);
        return list;
    }
}
