package com.artfess.yhxt.basedata.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.basedata.model.BizEmergencyRescueManagement;
import com.artfess.yhxt.statistics.vo.Org4MaintenanceVO;
import com.artfess.yhxt.statistics.vo.Org4culvertVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.basedata.model.BizMaintenanceWorkArea;
import com.artfess.yhxt.basedata.manager.BizMaintenanceWorkAreaManager;

import java.util.List;

/**
 * 养护工区统计 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xmz
 * @since 2022-04-19
 */
@RestController
@RequestMapping("/bizMaintenanceWorkArea/v1/")
@Api(tags = "养护工区统计")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizMaintenanceWorkAreaController extends BaseController<BizMaintenanceWorkAreaManager, BizMaintenanceWorkArea> {
    @PostMapping("/query")
    @ApiOperation(value = "养护工区-分页", httpMethod = "POST", notes = "养护工区-分页")
    public PageList<BizMaintenanceWorkArea> query(@ApiParam(name = "queryFilter", value = "查询对象") @RequestBody QueryFilter<BizMaintenanceWorkArea> queryFilter)  {

        return baseService.queryMaintenanceWorkArea(queryFilter);
    }


    @RequestMapping(value = "getAreaVo", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取工区统计", httpMethod = "POST", notes = "获取工区统计")
    public List<Org4MaintenanceVO> getAreaVo() throws Exception {
        return baseService.getMaintenanceCount();
    }


    @PostMapping("save")
    @ApiOperation(value = "保存或修改养护工区", httpMethod = "POST", notes = "保存或修改养护工区")
    public CommonResult<String> save(@RequestBody BizMaintenanceWorkArea bizMaintenanceWorkArea)  {
        baseService.saveOrUpdate(bizMaintenanceWorkArea);
        return new CommonResult<>(true,"操作成功");
    }

}
