package com.artfess.yhxt.basedata.controller;


import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.yhxt.basedata.model.BizCulvertInformation;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.yhxt.basedata.vo.CulvertCheckVo;
import com.artfess.yhxt.basedata.vo.CulvertRegularVo;
import com.artfess.yhxt.statistics.vo.Org4bridgeInfoVO;
import com.artfess.yhxt.statistics.vo.Org4culvertVO;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.basedata.manager.BizCulvertInformationManager;

import javax.annotation.Resource;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/**
 * 涵洞信息表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-07-28
 */
@RestController
@RequestMapping("/bizCulvertInformation/bizCulvertInformationmanager/v1/")
@Api(tags = "涵洞信息管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizCulvertInformationController extends BaseController<BizCulvertInformationManager, BizCulvertInformation> {
    @Resource
    BizCulvertInformationManager bizCulvertInformationManager;
    /**
     * 涵洞管理列表(分页条件查询)数据
     *
     * @param queryFilter
     * @return
     * @throws Exception PageJson
     * @throws
     */
    @PostMapping("/list")
    @ApiOperation(value = "涵洞管理数据列表", httpMethod = "POST", notes = "获取涵洞管理列表")
    public PageList<BizCulvertInformation> list(@ApiParam(name = "queryFilter", value = "查询对象") @RequestBody QueryFilter<BizCulvertInformation> queryFilter) throws Exception {
        return bizCulvertInformationManager.query(queryFilter);
    }


    @RequestMapping(value = "getCulvertVo", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取涵洞统计", httpMethod = "POST", notes = "获取涵洞统计")
    public List<Org4culvertVO> getCulvertVo() throws Exception {
        return baseService.getCulvertCount();
    }

    /**
     * 涵洞管理明细页面
     *
     * @param id
     * @return
     * @throws Exception ModelAndView
     */
    @GetMapping(value = "/get/{id}")
    @ApiOperation(value = "涵洞管理数据详情", httpMethod = "GET", notes = "涵洞管理数据详情")
    public BizCulvertInformation get(@ApiParam(name = "id", value = "业务对象主键", required = true) @PathVariable String id) throws Exception {
        return bizCulvertInformationManager.getByCulvertId(id);
    }

    /**
     * 新增涵洞管理
     *
     * @param BizCulvertInformation
     * @return
     * @throws Exception
     * @throws
     */
    @PostMapping(value = "/save")
    @ApiOperation(value = "新增,更新涵洞管理数据", httpMethod = "POST", notes = "新增,更新涵洞管理数据")
    public CommonResult<String> save(@ApiParam(name = "BizCulvertInformation", value = "涵洞管理业务对象", required = true) @RequestBody BizCulvertInformation BizCulvertInformation) throws Exception {
        String msg = "添加涵洞管理成功";
        if (StringUtil.isEmpty(String.valueOf(BizCulvertInformation.getId()))) {
            BizCulvertInformation.setIsDele("0");
            HashMap<String, Object> map = new HashMap<>();
            IUser user= ContextUtil.getCurrentUser();
            if(ObjectUtils.isNotEmpty(user)){
                map.put("tenant_id_", user.getTenantId());
            }
            int nextSequence =baseService.getNextSequence(map);
            BizCulvertInformation.setSn(nextSequence);
            bizCulvertInformationManager.saveCulvert(BizCulvertInformation);
        } else {
            bizCulvertInformationManager.updateCulvert(BizCulvertInformation);
            msg = "更新涵洞管理成功";
        }
        return new CommonResult<String>(msg);
    }

    /**
     * 删除涵洞管理记录
     *
     * @param id
     * @return
     * @throws Exception
     * @throws
     */
    @DeleteMapping(value = "/remove/{id}")
    @ApiOperation(value = "删除涵洞管理记录", httpMethod = "DELETE", notes = "删除涵洞管理记录")
    public CommonResult<String> remove(@ApiParam(name = "id", value = "业务主键", required = true) @PathVariable String id) throws Exception {
        bizCulvertInformationManager.remove(id);
        return new CommonResult<String>(true, "删除成功");
    }

    /**
     * 批量删除涵洞管理记录
     *
     * @param ids
     * @return
     * @throws Exception
     * @throws
     */
    @DeleteMapping(value = "/removes")
    @ApiOperation(value = "批量删除涵洞管理记录", httpMethod = "DELETE", notes = "批量删除涵洞管理记录")
    public CommonResult<String> removes(@ApiParam(name = "ids", value = "多个主键之间用逗号分隔", required = true) @RequestParam String... ids) throws Exception {
        bizCulvertInformationManager.removeByIds(Arrays.asList(ids));
        return new CommonResult<String>(true, "删除成功");
    }

    @RequestMapping(value="/getList",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "不分页查询涵洞明细信息",httpMethod = "POST")
    public PageList<BizCulvertInformation> getList(@ApiParam(name="queryFilter", value="不分页查询信息") @RequestBody QueryFilter<BizCulvertInformation> queryFilter) {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        PageBean pageBean = queryFilter.getPageBean();
        pageBean.setPageSize(PageBean.WITHOUT_PAGE);
        pageBean.setPage(1);
        queryFilter.setPageBean(pageBean);
        PageList<BizCulvertInformation>   road = baseService.queryBizCulvertInformation(queryFilter);
        return road;
    }

    @RequestMapping(value="/getJson",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询涵洞明细信息",httpMethod = "POST")
    public PageList<BizCulvertInformation> getJson(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BizCulvertInformation> queryFilter) {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        PageList<BizCulvertInformation> pageList = baseService.queryBizCulvertInformation(queryFilter);
        return  pageList;
    }

    @RequestMapping(value = "updateBatch", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "逻辑删除", httpMethod = "POST", notes = "逻辑删除")
    public CommonResult<String> updateBatchBizCulvertInformation(@ApiParam(name = "id", value = "涵洞ID", required = true) @RequestParam(value = "id", required = true) String id) throws Exception {

        if (StringUtils.isNotBlank(id))
            bizCulvertInformationManager.updateBizCulvertInformation(id);
        return new CommonResult<>(true, "删除成功");
    }

    @RequestMapping(value = "updateCulvertInformation", method = RequestMethod.DELETE, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "批量逻辑删除", httpMethod = "DELETE", notes = "批量逻辑删除")
    public CommonResult<String> updateCulvertInformation(
            @ApiParam(name = "ids", value = "涵洞ID集合以，隔开", required = true)
            @RequestParam(value = "ids", required = true) String ids) throws Exception {
        if (StringUtils.isNotBlank(ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<BizCulvertInformation> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_", idsList);
            updateWrapper.set("is_dele_", "1");
            bizCulvertInformationManager.update(null, updateWrapper);

        }

        return new CommonResult<>(true, "批量删除成功");
    }

    @RequestMapping(value = "/updateBySn", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "修改排序号", httpMethod = "POST")
    public CommonResult<String> updateBySn(@ApiParam(name = "params", value = "排序参数：Key：ID，Value：排序号") @RequestBody HashMap<String, Integer> params) throws Exception {
        baseService.updateSequence(params);
        return new CommonResult<>(true, "排序完成");
    }


    @RequestMapping(value="/getJsonVo",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询涵洞经常检查信息",httpMethod = "POST")
    public PageList<CulvertCheckVo> getJsonVo(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BizCulvertInformation> queryFilter) throws Exception {
        PageList<CulvertCheckVo> pageList = baseService.queryBizCulvert(queryFilter);
        return  pageList;
    }

    @RequestMapping(value="/getJsonRegularVo",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询涵洞定期检查信息",httpMethod = "POST")
    public PageList<CulvertRegularVo> getJsonRegularVo(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BizCulvertInformation> queryFilter) throws Exception {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        PageList<CulvertRegularVo> pageList = baseService.queryCulvertRegular(queryFilter);
        return  pageList;
    }
}
