/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.basedata.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.file.util.MinioUtil;
import com.artfess.yhxt.basedata.dao.BizEngineeringDrawingDao;
import com.artfess.yhxt.basedata.manager.AccessoryManager;
import com.artfess.yhxt.basedata.manager.BizCulvertInformationManager;
import com.artfess.yhxt.basedata.manager.BizEngineeringDrawingManager;
import com.artfess.yhxt.basedata.manager.BridgeInformationManager;
import com.artfess.yhxt.basedata.manager.SideSlopeInformationManager;
import com.artfess.yhxt.basedata.manager.TunnelInformationManager;
import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.yhxt.basedata.model.BizEngineeringDrawing;
import com.artfess.yhxt.basedata.vo.BizEngineeringDrawingVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class BizEngineeringDrawingManagerImpl
extends BaseManagerImpl<BizEngineeringDrawingDao, BizEngineeringDrawing>
implements BizEngineeringDrawingManager {
    @Resource
    BridgeInformationManager bridgeInformationManager;
    @Resource
    TunnelInformationManager tunnelInformationManager;
    @Resource
    SideSlopeInformationManager sideSlopeInformationManager;
    @Resource
    BizCulvertInformationManager culvertInformationManager;
    @Resource
    private AccessoryManager accessoryManager;

    @Override
    public PageList<BizEngineeringDrawing> queryBizEngineeringDrawing(QueryFilter<BizEngineeringDrawing> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<BizEngineeringDrawing> result = ((BizEngineeringDrawingDao)this.baseMapper).getBizEngineeringDrawing((IPage<BizEngineeringDrawing>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizEngineeringDrawing>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public void updateBizEngineeringDrawing(String id) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq(StringUtils.isNotBlank((CharSequence)id), (Object)"id_", (Object)id);
        updateWrapper.set((Object)"is_dele_", (Object)"1");
        ((BizEngineeringDrawingDao)this.baseMapper).update(null, (Wrapper)updateWrapper);
    }

    @Override
    public String minioDrawingUpload(MultipartFile file) {
        String miniourl = MinioUtil.getMinioUrl();
        if (file.isEmpty() || file.getSize() == 0L) {
            throw new RuntimeException("\u6587\u4ef6\u4e3a\u7a7a");
        }
        String fileName = file.getOriginalFilename();
        String name = DigestUtils.md5Hex((String)UUID.randomUUID().toString()) + fileName.substring(fileName.lastIndexOf("."));
        String url = null;
        try {
            url = MinioUtil.uploadRelative((MultipartFile)file, (String)"/drawing", (String)name, (String)"yhxt");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return miniourl + url;
    }

    @Override
    public void updateByBridgeCoordinate(String id, String x, String y) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"ID_", (Object)id);
        updateWrapper.set((Object)"X_", (Object)x);
        updateWrapper.set((Object)"Y_", (Object)y);
        this.bridgeInformationManager.update(null, (Wrapper)updateWrapper);
    }

    @Override
    public void updateByTunnelCoordinate(String id, String x, String y) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"ID_", (Object)id);
        updateWrapper.set((Object)"X_", (Object)x);
        updateWrapper.set((Object)"Y_", (Object)y);
        this.tunnelInformationManager.update(null, (Wrapper)updateWrapper);
    }

    @Override
    public void updateBySideSlopeCoordinate(String id, String x, String y) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"ID_", (Object)id);
        updateWrapper.set((Object)"X_", (Object)x);
        updateWrapper.set((Object)"Y_", (Object)y);
        this.sideSlopeInformationManager.update(null, (Wrapper)updateWrapper);
    }

    @Override
    public void updateByCulvertCoordinate(String id, String x, String y) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"ID_", (Object)id);
        updateWrapper.set((Object)"X_", (Object)x);
        updateWrapper.set((Object)"Y_", (Object)y);
        this.culvertInformationManager.update(null, (Wrapper)updateWrapper);
    }

    @Override
    public void saveVo(BizEngineeringDrawingVo bizEngineeringDrawingVo) {
        BizEngineeringDrawing bizEngineeringDrawing = bizEngineeringDrawingVo.getBizEngineeringDrawing();
        this.create((Model)bizEngineeringDrawing);
        List<Accessory> accessoryList = bizEngineeringDrawingVo.getAccessories();
        String id = bizEngineeringDrawing.getId();
        if (accessoryList.size() > 0) {
            accessoryList.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveBatch(accessoryList);
        }
    }

    @Override
    public void updateVo(BizEngineeringDrawingVo bizEngineeringDrawingVo) {
        BizEngineeringDrawing bizEngineeringDrawing = bizEngineeringDrawingVo.getBizEngineeringDrawing();
        List<Accessory> accessoryList = bizEngineeringDrawingVo.getAccessories();
        this.update((Model)bizEngineeringDrawing);
        String id = bizEngineeringDrawing.getId();
        if (accessoryList.size() > 0) {
            this.accessoryManager.delAccessoryBySourceId(id);
            accessoryList.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveOrUpdateBatch(accessoryList);
        }
    }

    @Override
    public BizEngineeringDrawingVo getVo(String id) {
        BizEngineeringDrawingVo bizEngineeringDrawingVo = new BizEngineeringDrawingVo();
        BizEngineeringDrawing bizEngineeringDrawing = (BizEngineeringDrawing)((Object)((BizEngineeringDrawingDao)this.baseMapper).selectById((Serializable)((Object)id)));
        List<Accessory> accessoryList = this.accessoryManager.getAccessoryBySourceId(id);
        bizEngineeringDrawingVo.setBizEngineeringDrawing(bizEngineeringDrawing);
        bizEngineeringDrawingVo.setAccessories(accessoryList);
        return bizEngineeringDrawingVo;
    }
}

