/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.basedata.manager.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.file.util.MinioUtil;
import com.artfess.uc.dao.OrgDao;
import com.artfess.uc.model.Org;
import com.artfess.yhxt.basedata.dao.BizCarEquipmentDao;
import com.artfess.yhxt.basedata.dao.BizVehicleDao;
import com.artfess.yhxt.basedata.manager.BizRoadIndexCodeManager;
import com.artfess.yhxt.basedata.manager.BizVehicleManager;
import com.artfess.yhxt.basedata.manager.RoadManager;
import com.artfess.yhxt.basedata.model.BizCarEquipment;
import com.artfess.yhxt.basedata.model.BizRoadIndexCode;
import com.artfess.yhxt.basedata.model.BizVehicle;
import com.artfess.yhxt.basedata.model.Road;
import com.artfess.yhxt.basedata.vo.BizRoadIndexCodeVO;
import com.artfess.yhxt.basedata.vo.VehicleCountVo;
import com.artfess.yhxt.statistics.vo.Org4MaintenanceUnitVO;
import com.artfess.yhxt.statistics.vo.Org4OperatingUnitVO;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.hikvision.artemis.sdk.ArtemisHttpUtil;
import com.hikvision.artemis.sdk.config.ArtemisConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.hasor.db.transaction.interceptor.Transactional;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class BizVehicleManagerImpl
extends BaseManagerImpl<BizVehicleDao, BizVehicle>
implements BizVehicleManager {
    @Resource
    private BizCarEquipmentDao bizCarEquipmentDao;
    @Resource
    private BaseContext baseContext;
    @Resource
    private PermissionUtils permissionUtils;
    @Resource
    private BizRoadIndexCodeManager roadIndexCodeManager;
    @Resource
    private OrgDao orgDao;
    @Resource
    private BizVehicleManager bizVehicleManager;
    @Resource
    private RoadManager roadManager;
    private static final String ARTEMIS_PATH = "/artemis";

    @Override
    public List<VehicleCountVo> getVehicleCountVo() {
        String orgId = StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId()) && !"0".equals(this.baseContext.getCurrentOrgId()) ? this.baseContext.getCurrentOrgId() : "1419863231459102720";
        ArrayList<Org> rtnList = new ArrayList<Org>();
        QueryWrapper rgQueryWrapper = new QueryWrapper();
        rgQueryWrapper.eq((Object)"is_dele_", (Object)"0");
        List allList = this.orgDao.selectList((Wrapper)rgQueryWrapper);
        ArrayList<VehicleCountVo> vos = new ArrayList<VehicleCountVo>();
        List<Org> list = this.getOrgChild(allList, orgId, rtnList);
        for (Org org : list) {
            VehicleCountVo vo = new VehicleCountVo();
            BeanUtils.copyProperties((Object)org, (Object)vo);
            vos.add(vo);
        }
        List<VehicleCountVo> returnList = this.getVehicleCountChild(vos, orgId);
        this.countCompanyCount(returnList);
        return returnList;
    }

    private void countCompanyCount(List<VehicleCountVo> vos) {
        Iterator<VehicleCountVo> it = vos.iterator();
        while (it.hasNext()) {
            VehicleCountVo vehicleCountVo = it.next();
            Integer grade = Integer.valueOf(vehicleCountVo.getGrade());
            List<String> roadList = new ArrayList<String>();
            if (grade < 4) {
                QueryWrapper roadQueryWrapper = new QueryWrapper();
                roadQueryWrapper.like((Object)"COMPANY_IDS_", (Object)vehicleCountVo.getId());
                roadList = this.roadManager.list((Wrapper)roadQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            } else if (grade == 4) {
                QueryWrapper roadByNameQueryWrapper = new QueryWrapper();
                roadByNameQueryWrapper.eq((Object)"NAME_", (Object)vehicleCountVo.getName());
                roadList = this.roadManager.list((Wrapper)roadByNameQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            }
            if (roadList.size() > 0) {
                vehicleCountVo = this.newCountVehicle(roadList, vehicleCountVo);
            } else {
                it.remove();
            }
            if (vehicleCountVo.getChirldren().size() <= 0 || Integer.valueOf(vehicleCountVo.getGrade()) >= 4) continue;
            this.countCompanyCount(vehicleCountVo.getChirldren());
        }
    }

    public VehicleCountVo newCountVehicle(List<String> ids, VehicleCountVo vehicleCountVo) {
        QueryWrapper carWrapper = new QueryWrapper();
        carWrapper.in((Object)"ROAD_SEGMENT_ID_", ids);
        carWrapper.eq((Object)"IS_DELE_", (Object)0);
        List cars = this.bizVehicleManager.list((Wrapper)carWrapper);
        if (cars.size() > 0) {
            Map<Integer, Long> collect = cars.stream().filter(e -> null != e.getType()).collect(Collectors.groupingBy(BizVehicle::getType, Collectors.counting()));
            if (null == collect) {
                vehicleCountVo.setBusinessNum(0L);
                vehicleCountVo.setCuringNum(0L);
            } else {
                Long num0 = collect.get(0);
                Long num1 = collect.get(1);
                if (null != num0) {
                    vehicleCountVo.setBusinessNum(num0);
                }
                if (null != num1) {
                    vehicleCountVo.setCuringNum(num1);
                }
            }
            if ("4".equals(vehicleCountVo.getGrade())) {
                vehicleCountVo.setRoadSegmentId(((BizVehicle)((Object)cars.get(0))).getRoadSegmentId());
            }
        }
        return vehicleCountVo;
    }

    private List<VehicleCountVo> getVehicleCountChild(List<VehicleCountVo> vos, String orgId) {
        ArrayList<VehicleCountVo> returnList = new ArrayList<VehicleCountVo>();
        for (VehicleCountVo entity : vos) {
            if (!orgId.equals(entity.getParentId())) continue;
            entity.setChirldren(this.getVehicleCountChild(vos, entity.getId()));
            returnList.add(entity);
        }
        return returnList;
    }

    public Map<String, List<Org4OperatingUnitVO>> get4OperatingCount(List<Org4OperatingUnitVO> lists) {
        return this.setOperating(lists);
    }

    public Map<String, List<Org4OperatingUnitVO>> setOperating(List<Org4OperatingUnitVO> list) {
        HashedMap returnMap = new HashedMap();
        Iterator<Org4OperatingUnitVO> it = list.iterator();
        int count = 0;
        while (it.hasNext()) {
            Org4OperatingUnitVO orgVO = it.next();
            Integer grade = Integer.valueOf(orgVO.getGrade());
            List<String> roadList = new ArrayList<String>();
            if (grade < 4) {
                QueryWrapper roadQueryWrapper = new QueryWrapper();
                roadQueryWrapper.like((Object)"COMPANY_IDS_", (Object)orgVO.getId());
                roadList = this.roadManager.list((Wrapper)roadQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            } else if (grade == 4) {
                QueryWrapper roadByNameQueryWrapper = new QueryWrapper();
                roadByNameQueryWrapper.eq((Object)"NAME_", (Object)orgVO.getName());
                roadList = this.roadManager.list((Wrapper)roadByNameQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            }
            if (roadList.size() > 0) {
                orgVO = this.newOperating(roadList, orgVO);
                count += orgVO.getAllCount();
            } else {
                it.remove();
            }
            if (orgVO.getChirldren().size() <= 0 || Integer.valueOf(orgVO.getGrade()) >= 4) continue;
            this.setOperating(orgVO.getChirldren());
        }
        returnMap.put(Integer.toString(count), list);
        return returnMap;
    }

    public Org4OperatingUnitVO newOperating(List<String> ids, Org4OperatingUnitVO orgVO) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"ROAD_SEGMENT_ID_", ids);
        wrapper.eq((Object)"IS_DELE_", (Object)"0");
        wrapper.eq((Object)"TYPE_", (Object)0);
        List list = this.list((Wrapper)wrapper);
        List patrolCar = list.stream().filter(vehicle -> Objects.equals(vehicle.getCarType(), "10")).collect(Collectors.toList());
        orgVO.setAllCount(list.size());
        if ("4".equals(orgVO.getGrade())) {
            orgVO.setRoadSegmentId(ids.get(0));
        }
        orgVO.setCarCount(patrolCar.size());
        return orgVO;
    }

    public Map<String, List<Org4MaintenanceUnitVO>> get4MaintenanceCount(List<Org4MaintenanceUnitVO> lists) {
        return this.setMaintenance(lists);
    }

    public Map<String, List<Org4MaintenanceUnitVO>> setMaintenance(List<Org4MaintenanceUnitVO> list) {
        HashedMap returnMap = new HashedMap();
        Iterator<Org4MaintenanceUnitVO> it = list.iterator();
        int count = 0;
        while (it.hasNext()) {
            Org4MaintenanceUnitVO orgVO = it.next();
            Integer grade = Integer.valueOf(orgVO.getGrade());
            List<String> roadList = new ArrayList<String>();
            if (grade < 4) {
                QueryWrapper roadQueryWrapper = new QueryWrapper();
                roadQueryWrapper.like((Object)"COMPANY_IDS_", (Object)orgVO.getId());
                roadList = this.roadManager.list((Wrapper)roadQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            } else if (grade == 4) {
                QueryWrapper roadByNameQueryWrapper = new QueryWrapper();
                roadByNameQueryWrapper.eq((Object)"NAME_", (Object)orgVO.getName());
                roadList = this.roadManager.list((Wrapper)roadByNameQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            }
            if (roadList.size() > 0) {
                orgVO = this.newMaintenance(roadList, orgVO);
                count += orgVO.getAllCount();
            } else {
                it.remove();
            }
            if (orgVO.getChirldren().size() <= 0 || Integer.valueOf(orgVO.getGrade()) >= 4) continue;
            this.setMaintenance(orgVO.getChirldren());
        }
        returnMap.put(Integer.toString(count), list);
        return returnMap;
    }

    public Org4MaintenanceUnitVO newMaintenance(List<String> ids, Org4MaintenanceUnitVO orgVO) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"ROAD_SEGMENT_ID_", ids);
        wrapper.eq((Object)"IS_DELE_", (Object)"0");
        wrapper.eq((Object)"TYPE_", (Object)1);
        List list = this.list((Wrapper)wrapper);
        List patrolCar = list.stream().filter(vehicle -> Objects.equals(vehicle.getCarType(), "10")).collect(Collectors.toList());
        List doubleCar = list.stream().filter(vehicle -> Objects.equals(vehicle.getCarType(), "1")).collect(Collectors.toList());
        List tipperTruck = list.stream().filter(vehicle -> Objects.equals(vehicle.getCarType(), "2")).collect(Collectors.toList());
        List cleanCar = list.stream().filter(vehicle -> Objects.equals(vehicle.getCarType(), "3")).collect(Collectors.toList());
        List waterCar = list.stream().filter(vehicle -> Objects.equals(vehicle.getCarType(), "4")).collect(Collectors.toList());
        List washingCar = list.stream().filter(vehicle -> Objects.equals(vehicle.getCarType(), "5")).collect(Collectors.toList());
        List crane = list.stream().filter(vehicle -> Objects.equals(vehicle.getCarType(), "6")).collect(Collectors.toList());
        List guardrail = list.stream().filter(vehicle -> Objects.equals(vehicle.getCarType(), "7")).collect(Collectors.toList());
        List spreader = list.stream().filter(vehicle -> Objects.equals(vehicle.getCarType(), "8")).collect(Collectors.toList());
        List aerialWork = list.stream().filter(vehicle -> Objects.equals(vehicle.getCarType(), "9")).collect(Collectors.toList());
        if ("4".equals(orgVO.getGrade())) {
            orgVO.setRoadSegmentId(ids.get(0));
        }
        orgVO.setPatrolCar(patrolCar.size());
        orgVO.setCleanCar(cleanCar.size());
        orgVO.setAerialWork(aerialWork.size());
        orgVO.setDoubleCar(doubleCar.size());
        orgVO.setTipperTruck(tipperTruck.size());
        orgVO.setWaterCar(waterCar.size());
        orgVO.setWashingCar(washingCar.size());
        orgVO.setCrane(crane.size());
        orgVO.setGuardrail(guardrail.size());
        orgVO.setSpreader(spreader.size());
        orgVO.setAllCount(list.size());
        return orgVO;
    }

    public List<Org> getOrgChild(List<Org> orgList, String parentId, List<Org> rtnList) {
        for (Org org : orgList) {
            if (!parentId.equals(org.getParentId())) continue;
            this.getOrgChild(orgList, org.getId(), rtnList);
            rtnList.add(org);
        }
        return rtnList;
    }

    public static List<Org4MaintenanceUnitVO> getMaintenanceChild(List<Org4MaintenanceUnitVO> allList, String pCode) {
        ArrayList<Org4MaintenanceUnitVO> returnList = new ArrayList<Org4MaintenanceUnitVO>();
        for (Org4MaintenanceUnitVO entity : allList) {
            if (!pCode.equals(entity.getParentId())) continue;
            entity.setChirldren(BizVehicleManagerImpl.getMaintenanceChild(allList, entity.getId()));
            returnList.add(entity);
        }
        return returnList;
    }

    public static List<Org4OperatingUnitVO> getOperatingChild(List<Org4OperatingUnitVO> allList, String pCode) {
        ArrayList<Org4OperatingUnitVO> returnList = new ArrayList<Org4OperatingUnitVO>();
        for (Org4OperatingUnitVO entity : allList) {
            if (!pCode.equals(entity.getParentId())) continue;
            entity.setChirldren(BizVehicleManagerImpl.getOperatingChild(allList, entity.getId()));
            returnList.add(entity);
        }
        return returnList;
    }

    @Override
    public PageList<BizVehicle> queryBizVehicle(QueryFilter<BizVehicle> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<BizVehicle> result = ((BizVehicleDao)this.baseMapper).getBizVehicle((IPage<BizVehicle>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizVehicle>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public String minioDrawingUpload(MultipartFile file) {
        String miniourl = MinioUtil.getMinioUrl();
        if (file.isEmpty() || file.getSize() == 0L) {
            throw new RuntimeException("\u6587\u4ef6\u4e3a\u7a7a");
        }
        String fileName = file.getOriginalFilename();
        String name = DigestUtils.md5Hex((String)UUID.randomUUID().toString()) + fileName.substring(fileName.lastIndexOf("."));
        String url = null;
        try {
            url = MinioUtil.uploadRelative((MultipartFile)file, (String)"/drawing", (String)name, (String)"yhxt");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return miniourl + url;
    }

    @Override
    public void minioDrawingDelete(String url) {
        String filePath = url.substring(url.lastIndexOf("/"));
        MinioUtil.removeObject((String)"yhxt", (String)("/" + filePath), (boolean)false);
    }

    @Override
    @Transactional
    public Boolean synchronizationCarData() {
        HashMap<String, Object> deleteMap = new HashMap<String, Object>(){
            {
                this.put("IS_DELE_", "0");
            }
        };
        this.bizCarEquipmentDao.deleteByMap(deleteMap);
        final String dataApi = "/artemis/api/resource/v1/regions/regionIndexCode/cameras";
        HashMap<String, String> path = new HashMap<String, String>(2){
            {
                super(x0);
                this.put("https://", dataApi);
            }
        };
        List roadIndexCodeList = this.roadIndexCodeManager.getAll();
        boolean flag = false;
        for (BizRoadIndexCode roadIndexCode : roadIndexCodeList) {
            String indexCode = roadIndexCode.getIndexCode();
            if (!StringUtils.isNotEmpty((CharSequence)indexCode)) continue;
            HashMap<String, String> bodyMap = new HashMap<String, String>();
            bodyMap.put("pageNo", "1");
            bodyMap.put("pageSize", "200");
            bodyMap.put("regionIndexCode", indexCode);
            bodyMap.put("treeCode", "0");
            String body = JSON.toJSONString(bodyMap);
            String result = ArtemisHttpUtil.doPostStringArtemis((Map)path, (String)body, null, null, (String)"application/json");
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            if (!"0".equals(jsonObject.get((Object)"code").toString())) continue;
            flag = true;
            JSONObject dataJson = JSONObject.parseObject((String)jsonObject.get((Object)"data").toString());
            List list = JSONArray.parseArray((String)dataJson.get((Object)"list").toString(), BizCarEquipment.class);
            for (BizCarEquipment bizCarEquipment : list) {
                String str = bizCarEquipment.getName();
                if ("50030000002160000035".equals(roadIndexCode.getIndexCode())) {
                    bizCarEquipment.setName(str.substring(10, 17));
                } else {
                    bizCarEquipment.setName(str.substring(8, 15));
                }
                bizCarEquipment.setCameraName(str.substring(str.lastIndexOf("-") + 1));
                bizCarEquipment.setRoadIndexCodeId(roadIndexCode.getId());
                bizCarEquipment.setId(UniqueIdUtil.getSuid());
                this.bizCarEquipmentDao.insert((Object)bizCarEquipment);
            }
        }
        return flag;
    }

    @Override
    public List<BizRoadIndexCodeVO> findAll() {
        QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        if (StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId())) {
            this.permissionUtils.addPermissionNo(queryFilter);
        }
        List roadIndexCodeList = this.roadIndexCodeManager.query(queryFilter).getRows();
        ArrayList<BizRoadIndexCodeVO> roadIndexCodeVOS = new ArrayList<BizRoadIndexCodeVO>();
        for (BizRoadIndexCode roadIndexCode : roadIndexCodeList) {
            Integer allCount = 0;
            Integer onlineCount = 0;
            BizRoadIndexCodeVO roadIndexCodeVO = new BizRoadIndexCodeVO();
            BeanUtils.copyProperties((Object)((Object)roadIndexCode), (Object)((Object)roadIndexCodeVO));
            List<BizRoadIndexCodeVO> carVOS = this.bizCarEquipmentDao.carNames(roadIndexCode.getId());
            for (BizRoadIndexCodeVO vo : carVOS) {
                List<BizRoadIndexCodeVO> details = this.bizCarEquipmentDao.selectdetail(roadIndexCode.getId(), vo.getName());
                for (BizRoadIndexCodeVO onlineVO : details) {
                    if (!"1".equals(onlineVO.getStatus())) continue;
                    onlineCount = onlineCount + 1;
                }
                vo.setList(details);
                allCount = allCount + details.size();
            }
            roadIndexCodeVO.setList(carVOS);
            roadIndexCodeVO.setAllCount(allCount);
            roadIndexCodeVO.setOnlineCount(onlineCount);
            roadIndexCodeVOS.add(roadIndexCodeVO);
        }
        return roadIndexCodeVOS;
    }

    static {
        ArtemisConfig.host = "172.16.200.100:446";
        ArtemisConfig.appKey = "29900884";
        ArtemisConfig.appSecret = "osPf2dpzAP9a59VQWGi6";
    }
}

