/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.util;

import java.math.BigDecimal;

public class ArithUtil {
    private static final int DEF_DIV_SCALE = 10;

    private ArithUtil() {
    }

    public static double add(double v1, double v2) {
        BigDecimal b1 = BigDecimal.valueOf(v1);
        BigDecimal b2 = BigDecimal.valueOf(v2);
        return b1.add(b2).setScale(2, 4).doubleValue();
    }

    public static double add(Float v1, Float v2) {
        BigDecimal b1 = BigDecimal.valueOf(v1.floatValue());
        BigDecimal b2 = BigDecimal.valueOf(v2.floatValue());
        return b1.add(b2).setScale(2, 4).doubleValue();
    }

    public static double sub(double v1, double v2) {
        BigDecimal b1 = BigDecimal.valueOf(v1);
        BigDecimal b2 = BigDecimal.valueOf(v2);
        return b1.subtract(b2).setScale(2, 4).doubleValue();
    }

    public static double mul(double v1, double v2) {
        BigDecimal b1 = BigDecimal.valueOf(v1);
        BigDecimal b2 = BigDecimal.valueOf(v2);
        return b1.multiply(b2).setScale(2, 4).doubleValue();
    }

    public static double div(double v1, double v2) {
        return ArithUtil.div(v1, v2, 10);
    }

    public static double div(double v1, double v2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be UserBean positive integer or zero");
        }
        if (v2 == 0.0) {
            return 0.0;
        }
        BigDecimal b1 = BigDecimal.valueOf(v1);
        BigDecimal b2 = BigDecimal.valueOf(v2);
        return b1.divide(b2, scale, 4).doubleValue();
    }

    public static double round(double v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be UserBean positive integer or zero");
        }
        BigDecimal b = BigDecimal.valueOf(v);
        BigDecimal one = BigDecimal.valueOf(1L);
        return b.divide(one, scale, 4).doubleValue();
    }
}

