/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.ledger.manager.impl;

import com.artfess.base.query.FieldSort;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.ledger.manager.ChangeLedgerManager;
import com.artfess.cqxy.processManagermant.manager.ChangeManagementManager;
import com.artfess.cqxy.processManagermant.model.ChangeManagement;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChangeLedgerManagerImpl
implements ChangeLedgerManager {
    @Autowired
    ChangeManagementManager cmm;
    @Autowired
    private SysDictionaryManager sdm;

    @Override
    public void exportDataToExcel(QueryFilter<ChangeManagement> queryFilter, HttpServletResponse response) throws IOException {
        queryFilter.getPageBean().setPageSize(-1);
        String fileName = "\u53d8\u66f4\u7ba1\u7406\u53f0\u8d26";
        List changeType = this.sdm.queryDictListItemsByCode("gcgl-bglx");
        HSSFWorkbook workbook = new HSSFWorkbook();
        queryFilter.withSorter(new FieldSort("bcm.PROJECT_ID_"));
        queryFilter.withSorter(new FieldSort("bcm.CHANGE_DATE_"));
        Map<String, List<ChangeManagement>> data = this.groupList(this.cmm.queryAllByPage(queryFilter).getRows());
        if (data.isEmpty()) {
            throw new RuntimeException("\u6ca1\u6709\u53ef\u5bfc\u51fa\u7684\u6570\u636e");
        }
        for (String key : data.keySet()) {
            List<ChangeManagement> list = data.get(key);
            String sheetName = list.get(0).getProjectInfo().getProjectName() + fileName;
            HSSFSheet sheet = workbook.createSheet(sheetName);
            HSSFCellStyle cellStyle = workbook.createCellStyle();
            HSSFFont font = workbook.createFont();
            font.setFontName("\u5b8b\u4f53");
            cellStyle.setFont(font);
            HSSFRow titleRow = sheet.createRow(0);
            BizUtils.handelCell(workbook, sheetName, titleRow.createCell(0), sheetName, true);
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 8));
            HSSFRow titleRow1 = sheet.createRow(1);
            String[] heards = new String[]{"\u5e8f\u53f7", "\u9879\u76ee\u540d\u79f0", "\u53d8\u66f4\u7c7b\u578b", "\u53d8\u66f4\u5185\u5bb9\u63cf\u8ff0", "\u53d8\u66f4\u7f16\u53f7", "\u53d8\u66f4\u589e\u52a0\uff08\u51cf\u5c11\uff09\u6295\u8d44\u91d1\u989d", "\u53d8\u66f4\u65f6\u95f4", "\u5ba1\u6279\u673a\u6784", "\u5907\u6ce8"};
            for (int i = 0; i < heards.length; ++i) {
                BizUtils.handelCell(workbook, sheetName, titleRow1.createCell(i), heards[i], true);
            }
            int row = 2;
            int index = 1;
            for (ChangeManagement ele : list) {
                HSSFRow dataRow = sheet.createRow(row);
                BizUtils.handelCell(workbook, cellStyle, font, sheetName, dataRow.createCell(0), String.valueOf(index), new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, font, sheetName, dataRow.createCell(1), ele.getProjectInfo().getProjectName(), new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, font, sheetName, dataRow.createCell(2), BizUtils.getDicValueByCode((List<DictModel>)changeType, ele.getChangeType()), new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, font, sheetName, dataRow.createCell(3), ele.getChangeContent(), new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, font, sheetName, dataRow.createCell(4), ele.getChangeCode(), new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, font, sheetName, dataRow.createCell(5), String.valueOf(ele.getChangePrice()), new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, font, sheetName, dataRow.createCell(6), BizUtils.handleDateFormat(ele.getChangeDate()), new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, font, sheetName, dataRow.createCell(7), "", new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, font, sheetName, dataRow.createCell(8), ele.getRemarks(), new boolean[0]);
                ++row;
                ++index;
            }
        }
        ExcelUtil.downloadExcel((HSSFWorkbook)workbook, (String)fileName, (HttpServletResponse)response);
    }

    private Map<String, List<ChangeManagement>> groupList(List<ChangeManagement> list) {
        HashMap<String, List<ChangeManagement>> resultMap = new HashMap<String, List<ChangeManagement>>();
        for (ChangeManagement ele : list) {
            if (resultMap.containsKey(ele.getProjectId())) {
                ((List)resultMap.get(ele.getProjectId())).add(ele);
                continue;
            }
            ArrayList<ChangeManagement> tmpList = new ArrayList<ChangeManagement>();
            tmpList.add(ele);
            resultMap.put(ele.getProjectId(), tmpList);
        }
        return resultMap;
    }
}

