package com.artfess.cqxy.projectApproval.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.projectApproval.model.DecisionAnnualPlan;
import com.artfess.cqxy.statistics.vo.StatisticsVo;
import com.baomidou.mybatisplus.extension.service.IService;
import com.artfess.cqxy.projectApproval.model.DecisionAnnualPlan;
import org.apache.ibatis.annotations.Param;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * 年度计划表(DecisionAnnualPlan)表服务接口
 *
 * @author 黎沐华
 * @since 2022-03-31 16:37:18
 */
public interface DecisionAnnualPlanManager extends BaseManager<DecisionAnnualPlan> {

    void importExcelData(MultipartFile file, String projectId);

    boolean deleteByIds(List<String> ids);

    void exportDatatoExcel(QueryFilter<DecisionAnnualPlan> queryFilter, HttpServletResponse response) throws IOException;

    /**
     * 通过ID获取数据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    DecisionAnnualPlan getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param queryFilter 通用查询器
     * @return 数据集合
     */
    PageList<DecisionAnnualPlan> queryAllByPage(QueryFilter<DecisionAnnualPlan> queryFilter);

    /**
     * 通过项目ID修改项目ID
     *
     * @param oldProjectIds
     * @param newProjectId
     *
     */
    void updateProjectIdByProiectId(String oldProjectIds, String newProjectId);

    /**
     * 根据条件查询每月投资情况
     * @param statisticsVo
     * @return
     */
    List<Map<String, String>> queryInvestment(StatisticsVo statisticsVo);
}

