package com.artfess.cqxy.processManagermant.model;


import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 过程管理 - 安全管理(BizSecurityManage)表实体类
 *
 * @author 黎沐华
 * @since 2022-03-04 15:40:47
 */
@Data
@TableName("BIZ_SECURITY_MANAGE")
@ApiModel(value="过程管理-安全管理对象-SecurityManage", description="过程管理-安全管理表")
public class SecurityManage extends BizModel<SecurityManage> {

    // 关联项目的信息放在开头，以便在导出时先导出项目中的配置，而不用进行额外的位置配置
    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的项目信息")
    private ProjectManagement projectInfo;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

    @Excel(name = "安检编号")
    @TableField("SECURITY_INSPECT_CODE_")
    @ApiModelProperty(value = "安检编号，（由后台生成，生成格式：AQRZ+年月日+01，01表示按天自增）")
    private String securityInspectCode;

    @Excel(name = "主题")
    @TableField("SECURITY_INSPECT_THEME_")
    @ApiModelProperty(value = "主题")
    private String securityInspectTheme;

    @Excel(name = "检查日期",format = "yyyy-MM-dd")
    @TableField("INSPECT_DATE_")
    @ApiModelProperty(value = "检查日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date inspectDate;

    @Excel(name = "基本情况")
    @TableField("BASE_SITUATION_")
    @ApiModelProperty(value = "基本情况")
    private String baseSituation;

    @Excel(name = "检查人")
    @TableField("INSPECT_USER_NAME_")
    @ApiModelProperty(value = "检查人")
    private String inspectUserName;

    @Excel(name = "现场检查情况")
    @TableField("CHECK_SITUATION_")
    @ApiModelProperty(value = "现场检查情况")
    private String checkSituation;

    @Excel(name = "处理要求及措施")
    @TableField("CHANGE_CONTRACT_NAME_")
    @ApiModelProperty(value = "处理要求及措施")
    private String changeContractName;

    @Excel(name = "复查情况")
    @TableField("REEXAMINATION_SITUATION_")
    @ApiModelProperty(value = "复查情况")
    private String reexaminationSituation;

    @Excel(name = "复查人")
    @TableField("REEXAMINATION_USER_")
    @ApiModelProperty(value = "复查人")
    private String reexaminationUser;

    @Excel(name = "备注")
    @TableField("REMARKS_")
    @ApiModelProperty(value = "备注")
    private String remarks;

//    @Excel(name = "工程规模")
    @TableField("PROJECT_SCALE_")
    @ApiModelProperty(value = "工程规模")
    private String projectScale;

//    @Excel(name = "形象进度")
    @TableField("IMAGE_PROGRESS_")
    @ApiModelProperty(value = "形象进度")
    private String imageProgress;

    @TableField("INSPECT_USER_ID_")
    @ApiModelProperty(value = "检查人ID")
    private String inspectUserId;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;

    /**
     * 获取主键值
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "SecurityManage{" +
                "id='" + id + '\'' +
                ", projectId='" + projectId + '\'' +
                ", securityInspectCode='" + securityInspectCode + '\'' +
                ", projectScale='" + projectScale + '\'' +
                ", imageProgress='" + imageProgress + '\'' +
                ", inspectUserId='" + inspectUserId + '\'' +
                ", inspectUserName='" + inspectUserName + '\'' +
                ", inspectDate=" + inspectDate +
                ", baseSituation='" + baseSituation + '\'' +
                ", checkSituation='" + checkSituation + '\'' +
                ", changeContractName='" + changeContractName + '\'' +
                ", reexaminationSituation='" + reexaminationSituation + '\'' +
                ", reexaminationUser='" + reexaminationUser + '\'' +
                ", remarks='" + remarks + '\'' +
                ", projectInfo=" + projectInfo +
                ", accessoryInfo=" + accessoryInfo +
                '}';
    }
}

