package com.artfess.cqxy.contract.model;


import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * (AdministrativePayment)表实体类
 *
 * @author makejava
 * @since 2022-11-28 10:07:39
 */
@Data
@TableName("biz_administrative_payment")
public class AdministrativePayment extends BizModel<AdministrativePayment> {

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

    @TableField("PROJECT_NAME_")
    @ApiModelProperty(value = "项目名称")
    private String projectName;

    @TableField("PAYS_NAME_")
    @ApiModelProperty(value = "缴费名称")
    private String paysName;

    @TableField("PAYS_TYPE_")
    @ApiModelProperty(value = "缴费名称")
    private String paysType;

    @TableField("PAYS_YEAR_")
    @ApiModelProperty(value = "缴费年份")
    private String paysYear;

    @TableField("PAYS_VALUE_")
    @ApiModelProperty(value = "缴费金额")
    private BigDecimal paysValue;

    @TableField("PAYS_DATE_")
    @ApiModelProperty(value = "缴费日期")
    private LocalDate paysDate;

    @TableField("REMARKS_")
    @ApiModelProperty(value = "备注")
    private String remarks;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;

    /**
     * 获取主键值
     *
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }
}

