package com.artfess.sysConfig.persistence.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.sysConfig.persistence.model.SysActuator;

import java.util.HashMap;
import java.util.List;

/**
 * @Program: edp
 * @Date: 2021/3/2
 * @Author: ZQF
 * @Description: 任务执行器信息
 */
public interface SysActuatorManager extends BaseManager<SysActuator> {

    /**
    * @Description: 保存执行器信息
    * @Param: sysActuator
    * @Return: java.lang.String
    * @Author: ZQF
    * @Date: 2021/3/2
    */
    String saveSysActuator(SysActuator sysActuator);

    /**
    * @Description: 批量修改排序号
    * @Param: params
    * @Return: java.lang.String
    * @Author: ZQF
    * @Date: 2021/3/2
    */
    String updateSequence(HashMap<String, Object> params);

    /**
    * @Description: 批量修改启用禁用状态
    * @Param: ids
    * @Param: flag
    * @Return: void
    * @Author: ZQF
    * @Date: 2021/3/2
    */
    void updateFlag(String ids, Integer flag);

    /**
    * @Description: 批量删除
    * @Param: ids
    * @Return: void
    * @Author: ZQF
    * @Date: 2021/3/2
    */
    void deleteBatch(String ids);

    /**
    * @Description: 不分页查询执行器信息（用于选择执行器）
    * @Param: sysActuator
    * @Return: java.util.List<com.artfess.portal.model.SysActuator>
    * @Author: ZQF
    * @Date: 2021/3/5
    */
    List<SysActuator> queryActuator(SysActuator sysActuator);


}
