package com.artfess.xqxt.meeting.vo;

import com.artfess.xqxt.meeting.model.BizTerminal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * @Description:
 * @Author: YangYong
 * @Date: 2022/11/3 17:29
 */
@Data
public class BizSiteParamExVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "会场名称")
    @TableField("name")
    private String name;

    @ApiModelProperty(value = "会场标识")
    @TableField("uri")
    private String uri;

    @ApiModelProperty(value = "会场类型")
    @TableField("type")
    private String type;

    @ApiModelProperty(value = "速率。单位：kbit/s、Mbit/s。")
    @TableField("rate")
    private Integer rate;

    @ApiModelProperty(value = "（可选）会场组织ID")
    @TableField("org_id")
    private String orgId;

    @ApiModelProperty(value = "（可选）会场IP地址")
    @TableField("ip_address")
    private String ipAddress;

    @ApiModelProperty(value = "（可选）会场型号")
    @TableField("model")
    private String model;

    @ApiModelProperty(value = "（可选）会场SN")
    @TableField("device_sn")
    private String deviceSn;

    @ApiModelProperty(value = "H.323、SIP协议会场注册SC的用户名。")
    @TableField("reg_user")
    private String regUser;

    @ApiModelProperty(value = "H.323、SIP协议会场注册SC的密码。")
    @TableField("reg_password")
    private String regPassword;

    @ApiModelProperty(value = "别名")
    @TableField("alias")
    private String alias;

    @ApiModelProperty(value = "（可选）视频能力参数。如果不填，则认为支持所有视频。")
    @TableField("video_cap_id")
    private String videoCapId;

    @ApiModelProperty(value = "DeviceStatus的id")
    @TableField("device_status_id")
    private String deviceStatusId;

    @ApiModelProperty(value = "分组id")
    @TableField("group_id")
    private String groupId;

    @ApiModelProperty(value = "创建人_单位_ID")
    @TableField("CREATED_OGN_ID")
    private String createdOgnId;

    @ApiModelProperty(value = "创建人_单位_名称")
    @TableField("CREATED_OGN_NAME")
    private String createdOgnName;

    @ApiModelProperty(value = "创建人_部门_ID")
    @TableField("CREATED_DEPT_ID")
    private String createdDeptId;

    @ApiModelProperty(value = "创建人_部门_名称")
    @TableField("CREATED_DEPT_NAME")
    private String createdDeptName;

    @ApiModelProperty(value = "创建人_ID")
    @TableField("CREATED_USER_ID")
    private String createdUserId;

    @ApiModelProperty(value = "创建人_姓名")
    @TableField("CREATED_USER_NAME")
    private String createdUserName;

    @ApiModelProperty(value = "创建时间")
    @TableField("CREATED_DATE")
    private LocalDateTime createdDate;

    @ApiModelProperty(value = "排序号")
    @TableField("SEQUENCE")
    private Integer sequence;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION")
    private Integer version;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;



    @ApiModelProperty(value = "0x00：H323 终端 0x01：E1 普通终端 0x02：E1 高清终端 0x03: SIP 终端 0x04：zte_sip 终端 0x05：4E1 双模 0x06: 323+tip 网真终端0x07：sip+tip 网真终端")
    @TableField("TER_TYPE_")
    private String terType;

    @ApiModelProperty(value = "0:呼叫号码 1:呼叫 IP 地址")
    @TableField("CALL_MODE_")
    private String callMode;

    @ApiModelProperty(value = "联系人名称")
    @TableField("CONTACT_NAME_")
    private String contactName;

    @ApiModelProperty(value = "联系电话")
    @TableField("TELEPHONE_NAME_")
    private String telephoneName;

    @ApiModelProperty(value = "邮件地址")
    @TableField("EMAIL_")
    private String email;

    @ApiModelProperty(value = "备注")
    @TableField("MEMO")
    private String memo;

    @ApiModelProperty(value = "连接状态：connected：连接； disconnected:断开")
    @TableField("STATUS_")
    private String status;

    @ApiModelProperty(value = "视频格式")
    @TableField("VIDEO_FORMAT_")
    private String videoFormat;

    @ApiModelProperty(value = "辅视频格式")
    @TableField("DUAL_VIDEO_FORMAT_")
    private String dualVideoFormat;

    @ApiModelProperty(value = "音频")
    @TableField("AUDIO_TYPE_")
    private String audioType;

    @ApiModelProperty(value = "是否哑音：true 当前哑音，会场 mac 关闭 false 非哑音，会场 mac 打开")
    @TableField("MUTE_")
    private Boolean mute;

    @ApiModelProperty(value = "是否静音 true：静音 false：非静音")
    @TableField("SILENT_")
    private Boolean silent;

    @ApiModelProperty(value = "是否声音最大端 true：声音最大端 false：非声音最大端")
    @TableField("MAX_VOLUME_")
    private Boolean maxVolume;

    @ApiModelProperty(value = "终端真实麦克状态（物理设备） on：开 false：关 unknown：未知")
    @TableField("MIC_STATE_")
    private String micState;

    @ApiModelProperty(value = "0：不在会议中； 1：在会议中")
    @TableField("IS_IN_CONF_")
    private String isInConf;

    @ApiModelProperty(value = "终端id")
    @TableField("TERMINAL_ID_")
    private String terminalId;
    
    private BizTerminal bizTerminal;

}
