package com.artfess.xqxt.meeting.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.bpm.persistence.model.DefaultBpmTask;
import com.artfess.xqxt.meeting.dto.MeetingDTO;
import com.artfess.xqxt.meeting.m900.bean.ParticipantStatusV2;
import com.artfess.xqxt.meeting.model.BizSiteParamEx;
import com.artfess.xqxt.meeting.model.Meeting;
import com.artfess.xqxt.meeting.model.MeetingUser;
import com.artfess.xqxt.meeting.vo.*;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

public interface MeetingManager extends BaseManager<Meeting> {

    PageList<MeetingVO> findByUserId(QueryFilter<Meeting> queryFilter);

    MeetingVO findById(String meetingId)  throws Exception;



    String insertMeetingVo(MeetingDTO dto);


    int updateMeetingVo(MeetingDTO dto);

    /**
     * 延长会议时间
     * @param meetingId
     * @param minutes
     * @return
     */
    String  delayMeeting(String meetingId,int meetingType,int minutes);


    /**
     * 委托参会发送信息
     * @param meeting
     * @param userName 委托人名称
     * @param entrustId 被委托人
     * @param entrustName 被委托人名称
     */
    void toEntrustSend(Meeting meeting,String userName,String entrustId,String entrustName);

    void sendMsg(Meeting meetingId,Integer type);

    String updateStatus(String id,Integer status);

    String updateStatusOver(Meeting meeting,Integer status);

    String endMeeting(String id);

    //会场静音
    String quiet(String id, String placeId);

    //取消会场静音
    String cancelQuiet(String id, String placeId);

    //会场呼叫
    String connect(String id, String placeIds);

    //会场断开
    String disconnect(String id, String placeIds);

    //会议终端状态
    ParticipantStatusV2[] participantStatusV2(String id);

    //添加会场
    String inviteParticipant(String id,String placeIds);

    //会议用户修改
    Integer updateMeetingUser(MeetingUser meetingUser);

    //签到
    Integer signIn(String meetingId,String userId);

    //取消签到
    Integer disSignIn(String meetingId,String userId);

    //签退
    Integer signOut(String meetingId,String userId);

    //取消签退
    Integer disSignOut(String meetingId,String userId);

    //签到人列表
    List<MeetingUser> signInUserList(String meetingId,Integer type);

    //签退人列表
    List<MeetingUser> signOutUserList(String meetingId,Integer type);

    /**
     * 签到签退人员统计
     * @param meetingId 会议ID
     * @return
     */
    SignInAndOutCountVo signInAndOutCount(String meetingId);

    /**
     * 根据会议ID、用户ID查询会议对应用户，如果没有则返回null
     *
     * @param meetingId 会议ID
     * @param userId 用户ID
     * @return
     */
    MeetingUser getMeetingUserByMeetingIdAndUserId(String meetingId, String userId);

    /**
     * 根据会议ID查询
     * @param meetingId
     * @return
     */
    List<BizSiteParamExVO> getSiteListByMeetingId(String meetingId);

    /**
     * 根据会议id导出
     */
    void exportMeeting(String id, HttpServletResponse response);

    //历史会议
    PageList<MeetingVO> getHistory(Integer type,QueryFilter<Meeting> queryFilter);

    MeetingCountVO getMeetingCount();

    //sha1加密字符
    Sha1VO getSha1(String url);

    /**
     * 同步中兴正在进行的会议
     */
    void synConferenceInfo();

    /**
     * 同步中兴将来预约的会议
     */
    void synConferenceReserved();
}
