package com.artfess.xqxt.meeting.manager;

import com.alibaba.fastjson.JSONArray;
import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.xqxt.meeting.model.BizMeetingTopic;
import com.artfess.xqxt.meeting.model.BizMeetingVote;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;

/**
 * 会议议题投票表 服务类
 *
 * @author 管理员
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-11-03
 */
public interface BizMeetingVoteManager extends BaseManager<BizMeetingVote> {

    boolean createVote(BizMeetingTopic topic);

    boolean changeVoteStatus(BizMeetingTopic topic);

    boolean vote(BizMeetingVote vote);

    Map<String, Boolean> checkUserVote(String topicID);

    void exportDataToExcel(QueryFilter<BizMeetingTopic> queryFilter, HttpServletResponse response) throws IOException;

    JSONArray getVoteResult(String meetingId);

    Integer votedCount(String topicId);

    PageList<BizMeetingTopic> selectByUserId(QueryFilter<BizMeetingTopic> queryFilter);

    BizMeetingTopic detail(String id);

    Integer checkTheme(String meetingId,String theme);
}
