package com.artfess.xqxt.meeting.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2022-08-05
 */
@ApiModel(value="BizMeetingPlaceName对象", description="")
@TableName("biz_meeting_place_name")
@Data
public class BizMeetingPlaceName extends BaseModel<BizMeetingPlaceName> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "会场名")
    @TableField("name")
    private String name;

    @ApiModelProperty(value = "创建人_单位_ID")
    @TableField("CREATED_OGN_ID")
    private String createdOgnId;

    @ApiModelProperty(value = "创建人_单位_名称")
    @TableField("CREATED_OGN_NAME")
    private String createdOgnName;

    @ApiModelProperty(value = "创建人_部门_ID")
    @TableField("CREATED_DEPT_ID")
    private String createdDeptId;

    @ApiModelProperty(value = "创建人_部门_名称")
    @TableField("CREATED_DEPT_NAME")
    private String createdDeptName;

    @ApiModelProperty(value = "创建人_ID")
    @TableField("CREATED_USER_ID")
    private String createdUserId;

    @ApiModelProperty(value = "创建人_姓名")
    @TableField("CREATED_USER_NAME")
    private String createdUserName;

    @ApiModelProperty(value = "创建时间")
    @TableField("CREATED_DATE")
    private LocalDateTime createdDate;

    @ApiModelProperty(value = "排序号")
    @TableField("SEQUENCE")
    private Integer sequence;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION")
    private Integer version;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;

}
