package com.artfess.xqxt.meeting.dao;

import com.artfess.workflow.runtime.dao.ScriptDao;
import com.artfess.xqxt.meeting.model.Meeting;
import com.artfess.xqxt.meeting.model.MeetingPlace;
import com.artfess.xqxt.meeting.model.MeetingUser;
import com.artfess.xqxt.meeting.vo.MeetingVO;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface MeetingDao extends BaseMapper<Meeting> {

    IPage<MeetingVO> selectByUserId(IPage<Meeting> convert2IPage,
                                    @Param(Constants.WRAPPER) Wrapper<Meeting> convert2Wrapper);

    List<MeetingUser> findUserName(String meetingId);

    List<MeetingPlace> findPlaceName(String meetingId);

    List<MeetingPlace> findPlaceNameByDeptID(@Param("meetingId")String meetingId, @Param("deptId")String deptId);

    List<MeetingUser> findWxUserId(String meetingId);

    List<Meeting> select4SendMsg();

    Integer updateStatus(@Param("id") String id,@Param("status") Integer status);

    List<Meeting> selectByStatus(@Param("status") Integer status);

    int countMeetingPlaceByMeetingIdAndTerminalId(@Param("meetingId")String meetingId,  @Param("terminalId")String terminalId);

}
