package com.artfess.xqxt.meeting.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.xqxt.meeting.manager.BizMeetingEntrustLogManager;
import com.artfess.xqxt.meeting.model.BizMeetingEntrustLog;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import javax.annotation.Resource;


/**
 * 参会人员变更记录 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author naf
 * @since 2023-05-17
 */
@RestController
@RequestMapping("/bizMeetingEntrustLog/v1/")
@Api(tags = "参会人员变更记录")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizMeetingEntrustLogController extends BaseController<BizMeetingEntrustLogManager, BizMeetingEntrustLog> {


    @Resource
    BizMeetingEntrustLogManager bizMeetingEntrustLogManager;



    @RequestMapping(value = "/entruset", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "参会人员变更", httpMethod = "POST")
    public CommonResult<String> entruset(@ApiParam(name = "BizMeetingEntrustLog", value = "参会人员变更记录") @RequestBody BizMeetingEntrustLog entity)  {
        int result = bizMeetingEntrustLogManager.entruset(entity);

        return new CommonResult<>(true,"参会人员已变更！");
    }







}
