/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.sysConfig.persistence.manager.impl;

import com.alibaba.druid.pool.DruidDataSource;
import com.artfess.base.datasource.DataSourceLoader;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DataSourceUtil;
import com.artfess.base.util.ExceptionUtil;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.SQLUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.sysConfig.persistence.dao.SysDataSourceDao;
import com.artfess.sysConfig.persistence.manager.SysDataSourceManager;
import com.artfess.sysConfig.persistence.model.SysDataSource;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service(value="sysDataSourceManager")
public class SysDataSourceManagerImpl
extends BaseManagerImpl<SysDataSourceDao, SysDataSource>
implements SysDataSourceManager,
DataSourceLoader {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SysDataSourceManagerImpl.class);
    @Autowired
    SysDataSourceDao sysDataSourceDao;

    public void create(SysDataSource sysDataSource) {
        super.create((Model)sysDataSource);
        this.updateDataSource(sysDataSource);
    }

    public DataSource loadByAlias(String alias) {
        SysDataSource sysDataSource = this.getByAlias(alias);
        return this.getDsFromSysSource(sysDataSource);
    }

    public void update(SysDataSource sysDataSource) {
        super.update((Model)sysDataSource);
        this.updateDataSource(sysDataSource);
    }

    private void updateDataSource(SysDataSource sysDataSource) {
        try {
            if (sysDataSource.getEnabled().booleanValue()) {
                DataSource dataSource = this.getDsFromSysSource(sysDataSource);
                DataSourceUtil.addDataSource((String)sysDataSource.getAlias(), (DataSource)dataSource, (boolean)true);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            LOGGER.error(ExceptionUtil.getExceptionMessage((Throwable)e));
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            LOGGER.error(ExceptionUtil.getExceptionMessage((Throwable)e));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error(ExceptionUtil.getExceptionMessage((Throwable)e));
        }
    }

    @Override
    public DataSource getDsFromSysSource(SysDataSource sysDataSource) {
        try {
            String initMethodStr;
            Class<?> _class = null;
            _class = Class.forName(sysDataSource.getClassPath());
            DataSource sqldataSource = null;
            sqldataSource = (DataSource)_class.newInstance();
            String settingJson = sysDataSource.getSettingJson();
            ArrayNode arrayNode = (ArrayNode)JsonUtil.toJsonNode((String)settingJson);
            for (int i = 0; i < arrayNode.size(); ++i) {
                ObjectNode jo = (ObjectNode)arrayNode.get(i);
                Object value = BeanUtils.convertByActType((String)JsonUtil.getString((JsonNode)jo, (String)"type"), (String)JsonUtil.getString((JsonNode)jo, (String)"value"));
                BeanUtils.setProperty((Object)sqldataSource, (String)JsonUtil.getString((JsonNode)jo, (String)"name"), (Object)value);
            }
            if (sqldataSource instanceof DruidDataSource) {
                ((DruidDataSource)sqldataSource).setBreakAfterAcquireFailure(true);
            }
            if (!StringUtil.isEmpty((String)(initMethodStr = sysDataSource.getInitMethod()))) {
                Method method = _class.getMethod(initMethodStr, new Class[0]);
                method.invoke((Object)sqldataSource, new Object[0]);
            }
            return sqldataSource;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.debug(e.getMessage());
            return null;
        }
    }

    @Override
    public boolean checkConnection(SysDataSource sysDataSource) {
        return this.checkConnection(this.getDsFromSysSource(sysDataSource), sysDataSource.getCloseMethod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkConnection(DataSource dataSource, String closeMethod) {
        boolean b = false;
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            b = true;
        }
        catch (SQLException exc) {
            this.closeInvoke(closeMethod);
            throw new BaseException("\u8fde\u63a5\u5931\u8d25\uff1a" + exc.getMessage(), (Throwable)exc);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.closeInvoke(closeMethod);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return b;
    }

    private void closeInvoke(String closeMethod) {
        if (!StringUtil.isEmpty((String)closeMethod) && closeMethod.split("\\|").length >= 2) {
            String cp = closeMethod.split("\\|")[0];
            String mn = closeMethod.split("\\|")[1];
            try {
                Class<?> _class = Class.forName(cp);
                Method method = _class.getMethod(mn, null);
                method.invoke(null, null);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public List<SysDataSource> getSysDataSourcesInBean() {
        Map map;
        ArrayList<SysDataSource> result = new ArrayList<SysDataSource>();
        try {
            map = DataSourceUtil.getDataSources();
        }
        catch (Exception e) {
            return result;
        }
        QueryFilter queryFilter = QueryFilter.build().withDefaultPage().withQuery(new QueryField("enabled_", (Object)1));
        PageList query = this.query(queryFilter);
        List sysDataSources = query.getRows();
        for (Object key : map.keySet()) {
            for (SysDataSource sysDataSource : sysDataSources) {
                if (!sysDataSource.getAlias().equals(key.toString())) continue;
                result.add(sysDataSource);
            }
        }
        return result;
    }

    @Override
    public SysDataSource getByAlias(String alias) {
        QueryFilter queryFilter = QueryFilter.build().withDefaultPage().withQuery(new QueryField("alias_", (Object)alias));
        PageList sysDataSources = this.query(queryFilter);
        if (sysDataSources != null && !sysDataSources.getRows().isEmpty()) {
            return (SysDataSource)((Object)sysDataSources.getRows().get(0));
        }
        return null;
    }

    @Override
    public Map<String, DataSource> getDataSource() {
        List<SysDataSource> list = ((SysDataSourceDao)this.baseMapper).getDataSource(true, true);
        HashMap<String, DataSource> maps = new HashMap<String, DataSource>();
        for (SysDataSource sysDataSource : list) {
            DataSource ds = this.getDsFromSysSource(sysDataSource);
            if (ds == null) continue;
            maps.put(sysDataSource.getAlias(), ds);
        }
        return maps;
    }

    @Override
    public SysDataSource getDefaultDataSource() {
        SysDataSource defaultDataSource = new SysDataSource();
        defaultDataSource.setAlias("LOCAL");
        defaultDataSource.setName("\u672c\u5730\u6570\u636e\u6e90");
        defaultDataSource.setDbType(SQLUtil.getDbType());
        return defaultDataSource;
    }

    @Override
    public boolean isAliasExist(String alias) {
        SysDataSource sysDataSource = this.getByAlias(alias);
        return BeanUtils.isNotEmpty((Object)((Object)sysDataSource));
    }

    @Override
    public String export(String[] idList) throws Exception {
        if (BeanUtils.isEmpty((Object)idList)) {
            return "";
        }
        ArrayList<Model> list = new ArrayList<Model>();
        for (String s : idList) {
            list.add(this.get((Serializable)((Object)s)));
        }
        if (BeanUtils.isEmpty(list)) {
            return "";
        }
        return JsonUtil.toJson(list);
    }

    @Override
    public void importFile(String unZipFilePath) throws Exception {
        try {
            String json = FileUtil.readFile((String)(unZipFilePath + File.separator + "sysDataSource.json"));
            List list = (List)JsonUtil.toBean((String)json, List.class);
            for (Object o : list) {
                SysDataSource sysDataSource = (SysDataSource)((Object)JsonUtil.toBean((String)JsonUtil.toJson(o), SysDataSource.class));
                SysDataSource byAlias = this.getByAlias(sysDataSource.getAlias());
                if (BeanUtils.isNotEmpty((Object)((Object)byAlias))) {
                    if (byAlias.getId().equals(sysDataSource.getId())) {
                        ((SysDataSourceDao)this.baseMapper).updateById((Object)sysDataSource);
                        continue;
                    }
                    throw new BaseException("\u522b\u540d\u3010" + sysDataSource.getAlias() + "\u3011\u5df2\u5b58\u5728");
                }
                sysDataSource.setId(null);
                ((SysDataSourceDao)this.baseMapper).insert((Object)sysDataSource);
            }
        }
        catch (Exception e) {
            throw new BaseException("\u5bfc\u5165\u5931\u8d25:" + e.getMessage());
        }
    }
}

