import req from '@/request'

const portal = window.context.portal

// 表格分页
export function getMonthArrangeInfo(data) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/bizInspectRankUser/v1/findMonthArrangeInfo?queryDate=` + data.queryDate + '&orgId=' + data.orgId + `${data.rankGroupId ? '&rankGroupId=' + data.rankGroupId : ''}`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 表格分页
export function getUsersByOrg(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/bizBaseTeamMember/v1/authByPage`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 批量保存排班信息
export function saveArrangeInfo(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/bizInspectRankUser/v1/saveList`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 获取排班信息详情
export function getArrangeInfoDetail(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/bizInspectRankUser/v1/` + id)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 删除排班
export function deleteArrangeInfo(id) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/bizInspectRankUser/v1/` + id)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}