import req from '@/request'

const portal = window.context.portal

// 拖车部门汇总统计
export function TrailerDept(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizRescueInfo/v1/count/road`, data)
      .then(res => {
        let resData = res.data || {}
        resData.urlKey = 'TrailerDept'
        resolve(resData)
      })
      .catch(err => reject(err))
  })
}

// 拖车人员汇总统计 (接口未出，待优化)
export function TrailerUser(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/patrol/bizInspectionTask/v1/count/user`, data)
      .then(res => {
        let resData = res.data || {}
        resData.urlKey = 'TrailerUser'
        resolve(resData)
      })
      .catch(err => reject(err))
  })
}

// 拖车部门汇总统计导出
export function TrailerDeptExport(data) {
  return new Promise((resolve, reject) => {
    req.downloadPostCopy(portal + `/event/bizRescueInfo/v1/export/road`, data)
      .then(res => {
        let resData = res.data || {}
        resolve(resData)
      })
      .catch(err => reject(err))
  })
}

// 拖车人员汇总统计 (接口未出，待优化)
export function TrailerUserExport(data) {
  return new Promise((resolve, reject) => {
    req.downloadPostCopy(portal + `/patrol/bizInspectionTask/v1/export/user`, data)
      .then(res => {
        let resData = res.data || {}
        resolve(resData)
      })
      .catch(err => reject(err))
  })
}
