import req from '@/request'

const portal = window.context.portal

// 日统计
export function theRoadNetworkIsOperatingDay(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizEventInfo/v1/dayReport`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 月统计
export function theRoadNetworkIsOperatingMonth(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizEventInfo/v1/monthReport`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

export function getTree() {
  return new Promise((resolve, reject) => {
    req.get(portal + `/uc/org/roadTree`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 日统计明细导出
export function exportDayReport(data) {
  return new Promise((resolve, reject) => {
    req.downloadPostCopy(portal + `/event/bizEventInfo/v1/dayReport/export`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 月统计明细导出
export function exportMonthReport(data) {
  return new Promise((resolve, reject) => {
    req.downloadPostCopy(portal + `/event/bizEventInfo/v1/monthReport/export`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

