import req from '@/request'

const portal = window.context.portal

// 表格分页
export function tableData(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizEventInfo/v1/query`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}
// 事件新增
export function tableAdd(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizEventInfo/v1/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 事件修改
export function tableEdit(data) {
  return new Promise((resolve, reject) => {
    req.put(portal + `/event/bizEventInfo/v1/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 委派
export function eventAppoint(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizEventInfo/v1/appoint`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}
// 撤回
export function eventRevocation(id) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizEventInfo/v1/cancel?id=${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}
// 事件删除
export function tableDelete(ids) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/event/bizEventInfo/v1/?ids=${ids}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格详情
export function tableDetail(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/event/bizEventInfo/v1/full/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格详情
export function personAndCarInfo(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/bizBaseTeam/v1/getTeamData?id=${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 事件完结
export function eventCompleted(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizEventHandle/v1/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 获取排班人员
export function getSchedulingPerson(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/open/monitor/v1/rank/user`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}