import req from '@/request'

const portal = window.context.portal

// 表格分页
export function reportData(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/reportsMaster/v1/query`, data)
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}

// 表格新增
export function reportAdd(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/reportsMaster/v1/`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 表格详情
export function getReportDetail(id) {
    return new Promise((resolve, reject) => {
        req.get(portal + `/bizReports/v1/${id}`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 表格修改
export function reportEdit(data) {
    return new Promise((resolve, reject) => {
        req.put(portal + `/bizReports/v1/`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 表格删除
export function reportDelete(ids) {
    return new Promise((resolve, reject) => {
        req.remove(portal + `/bizReports/v1/${ids}`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 发布/取消报表 toggle切换式接口
export function publishReport(id) {
    return new Promise((resolve, reject) => {
        req.post(portal + '/bizReports/v1/issue/' + id)
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}

// 填报报表
export function fillReportData(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + '/bizReports/v1/getTodoReports', data)
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}

// 待报表填报
export function todoReportData() {
    return new Promise((resolve, reject) => {
        req.post(portal + '/bizReports/v1/todo')
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}

// 查询报表汇总信息
export function collectReportData(model, data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/${model}/v1/collect`, data)
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}

// 报表授权保存
export function reportAuth(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + '/bizReportsAuthority/v1/batchSave', data)
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}

// 报表授权查询
export function getReportAuth(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + '/bizReportsAuthority/v1/query', data)
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}

// 报表填报上报
export function reportPublish(id) {
    return new Promise((resolve, reject) => {
        req.get(portal + `/reportsMaster/v1/issue/` + id)
            .then(res => {
                resolve(res?.data || {})
            })
            .catch(err => reject(err))
    })
}

// 报表明细----报表明细
// 模板下载
export function downloadModel(modelDetail) {
    return new Promise((resolve, reject) => {
        req.downloadGet(portal + `/${modelDetail}/v1/downModel`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 明细导出
export function exportDetailData(modelDetail, data) {
    return new Promise((resolve, reject) => {
        req.downloadPostCopy(portal + `/${modelDetail}/v1/export`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 批量保存
export function saveDetailData(modelDetail, reportsId, data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/${modelDetail}/v1/batchSave/${reportsId}`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 删除主表 
export function deleteDetail(id) {
    return new Promise((resolve, reject) => {
        req.remove(portal + `/reportsMaster/v1/${id}`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}


// 根据主表id查询明细列表  
export function getDetailData(modelDetail, mainId) {
    return new Promise((resolve, reject) => {
        req.get(portal + `/${modelDetail}/v1/query/${mainId}`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 查询明细列表  
export function queryDetailData(modelDetail, data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/${modelDetail}/v1/query`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}