import req from '@/request'

const portal = window.context.portal

// 获取快捷菜单数据
export function getSwiftMenus(parentMenuPath = '') {
  return new Promise((resolve, reject) => {
    req.get(portal + `/sys/sysSwiftMenu/v1/getSwiftMenus?parentMenuPath=${parentMenuPath}`)
      .then(res => resolve(res.data || []))
      .catch(err => reject(err))
  })
}

// 新增
export function saveMenus(menuAlias) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/sys/sysSwiftMenu/v1/save?menuAlias=${menuAlias}`)
      .then(res => resolve(res))
      .catch(err => reject(err))
  })
}

// 删除
export function removeSwiftMenus(menuAlias) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/sys/sysSwiftMenu/v1/removeSwiftMenus?menuAlias=${menuAlias}`)
      .then(res => resolve(res))
      .catch(err => reject(err))
  })
}

// 更改排序
export function updateSequence(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/sys/sysSwiftMenu/v1/updateSequence`, data)
      .then(res => resolve(res))
      .catch(err => reject(err))
  })
}


