import req from '@/request'

const portal = window.context.portal

// 巡查部门汇总统计
export function InspectionDept(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/patrol/bizInspectionTask/v1/count/road`, data)
      .then(res => {
        let resData = res.data || {}
        resData.urlKey = 'InspectionDept'
        resolve(resData)
      })
      .catch(err => reject(err))
  })
}

// 巡检人员汇总统计
export function InspectionUser(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/patrol/bizInspectionTask/v1/count/user`, data)
      .then(res => {
        let resData = res.data || {}
        resData.urlKey = 'InspectionUser'
        resolve(resData)
      })
      .catch(err => reject(err))
  })
}

// 巡检人员汇总统计
export function InspectionContent(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/patrol/bizInspectionTask/v1/count/content`, data)
      .then(res => {
        let resData = res.data || {}
        resData.urlKey = 'InspectionContent'
        resolve(resData)
      })
      .catch(err => reject(err))
  })
}

// 巡检任务完成情况统计
export function InspectionTaskCompletion(data) {
  let queryData = {
    'endTime': '',
    'orgList': [],
    'startTime': ''
  }
  const {querys = []} = data
  let taskDate = querys.find(item => item.property == 't.task_date_')
  if (taskDate) {
    queryData.startTime = taskDate.value[0]
    queryData.endTime = taskDate.value[1]
  }
  let orgData = querys.find(item => item.property == 't.road_id_')
  if (orgData) {
    queryData.orgList = orgData.value
  }
  return new Promise((resolve, reject) => {
    req.post(portal + `/patrol/bizInspectionTask/v1/task/content`, queryData)
      .then(res => {
        let resData = res.data || {}
        resData.urlKey = 'InspectionTaskCompletion'
        resolve(resData)
      })
      .catch(err => reject(err))
  })
}

// 巡查部门汇总统计导出
export function InspectionDeptExport(data) {
  return new Promise((resolve, reject) => {
    req.downloadPostCopy(portal + `/patrol/bizInspectionTask/v1/export/road`, data)
      .then(res => {
        let resData = res.data || {}
        resolve(resData)
      })
      .catch(err => reject(err))
  })
}

// 巡检人员汇总统计导出
export function InspectionUserExport(data) {
  return new Promise((resolve, reject) => {
    req.downloadPostCopy(portal + `/patrol/bizInspectionTask/v1/export/user`, data)
      .then(res => {
        let resData = res.data || {}
        resolve(resData)
      })
      .catch(err => reject(err))
  })
}

// 巡检人员汇总统计导出
export function InspectionContentExport(data) {
  return new Promise((resolve, reject) => {
    req.downloadPostCopy(portal + `/patrol/bizInspectionTask/v1/export/content`, data)
      .then(res => {
        let resData = res.data || {}
        resolve(resData)
      })
      .catch(err => reject(err))
  })
}

// 巡检任务完成情况统计导出
export function InspectionTaskCompletionExport(data) {
  let queryData = {
    'endTime': '',
    'orgList': [],
    'startTime': ''
  }
  const {querys = []} = data
  let taskDate = querys.find(item => item.property == 't.task_date_')
  if (taskDate) {
    queryData.startTime = taskDate.value[0]
    queryData.endTime = taskDate.value[1]
  }

  let orgData = querys.find(item => item.property == 't.road_id_')
  if (orgData) {
    queryData.orgList = orgData.value
  }

  return new Promise((resolve, reject) => {
    req.downloadPostCopy(portal + `/patrol/bizInspectionTask/v1/export/task/content`, queryData)
      .then(res => {
        let resData = res.data || {}
        resolve(resData)
      })
      .catch(err => reject(err))
  })
}

